% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.trait.R
\name{merging.trait}
\alias{merging.trait}
\title{Generation of genomic traits}
\usage{
merging.trait(
  population,
  merge = NULL,
  trait.name = NULL,
  bv.standard = FALSE,
  mean.target = NULL,
  var.target = NULL,
  verbose = TRUE,
  set.zero = FALSE,
  new.phenotype.correlation = NULL,
  new.residual.correlation = NULL
)
}
\arguments{
\item{population}{Population list}

\item{merge}{Vector containing the traits to merge (e.g. c(2,3))}

\item{trait.name}{Name of the trait generated}

\item{bv.standard}{Set TRUE to standardize trait mean and variance via bv.standardization()}

\item{mean.target}{Target mean}

\item{var.target}{Target variance}

\item{verbose}{Set to FALSE to not display any prints}

\item{set.zero}{Set to TRUE to have no effect on the 0 genotype (or 00 for QTLs with 2 underlying SNPs)}

\item{new.phenotype.correlation}{(OLD! - use new.residual.correlation) Correlation of the simulated enviromental variance}

\item{new.residual.correlation}{Correlation of the simulated enviromental variance}
}
\value{
Population-list with one or more additional new traits
}
\description{
Generation of the trait in a starting population
}
\examples{
population <- creating.diploid(nsnp=1000, nindi=100)
population <- creating.trait(population, n.additive=c(100,100))
population <- merging.trait(population, merge = c(1,2))
}
