% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship.emp.R
\name{kinship.emp.fast}
\alias{kinship.emp.fast}
\title{Approximate empirical kinship}
\usage{
kinship.emp.fast(
  population = NULL,
  animals = NULL,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  ibd.obs = 200,
  hbd.obs = 50
)
}
\arguments{
\item{population}{Population list}

\item{animals}{List of animals to compute kinship for}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{ibd.obs}{Number of Individual pairs to sample for IBD estimation}

\item{hbd.obs}{Number of Individuals to sample for HBD estimation}
}
\value{
Empirical kinship matrix (IBD-based since Founders) per gen/database/cohort
}
\description{
Function to compute empirical kinship for a set of individuals (not all pairs of individuals are evaluated)
}
\examples{
data(ex_pop)
kinship.emp.fast(population=ex_pop,gen=2)
}
