% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pca.R
\name{get.pca}
\alias{get.pca}
\title{Principle components analysis}
\usage{
get.pca(
  population,
  path = NULL,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  coloring = "group",
  components = c(1, 2),
  plot = TRUE,
  pch = 1,
  export.color = FALSE,
  use.id = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{path}{Location were to save the PCA-plot}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{coloring}{Coloring by "group", "sex", "plain"}

\item{components}{Default: c(1,2) for the first two principle components}

\item{plot}{Set to FALSE to not generate a plot}

\item{pch}{Point type in the PCA plot}

\item{export.color}{Set to TRUE to export the per point coloring}

\item{use.id}{Set TRUE to display IDs instead of dots in the PCA plot}
}
\value{
Principle components of gen/database/cohorts selected individuals
}
\description{
Function to perform a principle component analysis
}
\examples{
data(ex_pop)
get.pca(ex_pop, gen=2)
}
