% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bv.standardization.R
\name{bv.standardization}
\alias{bv.standardization}
\title{BV standardization}
\usage{
bv.standardization(
  population,
  mean.target = NA,
  var.target = NA,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  adapt.bve = TRUE,
  adapt.pheno = NULL,
  verbose = FALSE,
  set.zero = FALSE,
  adapt.sigma.e = FALSE,
  traits = NULL
)
}
\arguments{
\item{population}{Population list}

\item{mean.target}{Target mean}

\item{var.target}{Target variance}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{adapt.bve}{Modify previous breeding value estimations by scaling (default: TRUE)}

\item{adapt.pheno}{Modify previous phenotypes by scaling (default: TRUE)}

\item{verbose}{Set to TRUE to display prints}

\item{set.zero}{Set to TRUE to have no effect on the 0 genotype (or 00 for QTLs with 2 underlying SNPs)}

\item{adapt.sigma.e}{Set to TRUE to scale sigma.e values used based on scaling}

\item{traits}{Use this parameter to only perform scaling of these traits (alternatively set values in mean/var.target to NA, default: all traits)}
}
\value{
Population-list with scaled QTL-effects
}
\description{
Function to get mean and genetic variance of a trait to a fixed value
}
\examples{
population <- creating.diploid(nsnp=1000, nindi=100, n.additive=100)
population <- bv.standardization(population, mean.target=200, var.target=5)
}
