% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradients.R
\name{integrate_sine}
\alias{integrate_sine}
\title{Integrate sin exponential}
\usage{
integrate_sine(x, alpha, beta, delta, omega)
}
\arguments{
\item{x}{Numeric vector. Observations at which the integral is computed.}

\item{alpha}{Numeric scalar. Stability parameter of the stable distribution
(0 < \eqn{\alpha \le 2}), controlling tail thickness.}

\item{beta}{Numeric scalar. Skewness parameter of the stable distribution
(\eqn{-1 \le \beta \le 1}).}

\item{delta}{Numeric scalar. Location parameter of the stable distribution.}

\item{omega}{Numeric scalar. Scale parameter of the stable distribution
(omega > 0).}
}
\value{
Numeric vector of integral values.
}
\description{
Computes the integral of the sin exponential function for stable distributions.
}
