% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estConnectivity.R
\name{diffMC}
\alias{diffMC}
\alias{diffStrength}
\title{Pairwise differences between two or more independent MC estimates}
\usage{
diffMC(estimates, nSamples = 1e+05, alpha = 0.05, returnSamples = FALSE)

diffStrength(estimates, nSamples = 1e+05, alpha = 0.05, returnSamples = FALSE)
}
\arguments{
\item{estimates}{List of at least two MC estimates, provided by the estMC
function. If this is a named list (recommended), the function will use
these names in labeling the differences.}

\item{nSamples}{A positive integer, number of samples (with replacement)
to draw from each pair of MC estimates (default 100000).  If set to NULL,
compares all MC samples from each pair.}

\item{alpha}{Level for confidence/credible intervals provided.}

\item{returnSamples}{Should the function return all the sampled differences?
Defaults to FALSE to reduce storage requirements. Change to TRUE to
compute your own summary statistics.}
}
\value{
\code{diffMC} returns a list with elements:
\describe{
  \item{\code{meanDiff, medianDiff}}{Vectors with mean and medians of sampled
     differences for each pairwise comparison. Estimates of difference
     between MC values incorporating parametric uncertainty.}
  \item{\code{seDiff}}{Vector with standard errors of MC differences for each
     pairwise comparison, estimated from SD of sampled differences.}
  \item{\code{simpleCI}}{Matrix of \code{1 - alpha} confidence intervals for
     MC differences, estimated as \code{alpha/2} and \code{1 - alpha/2}
     quantiles of \code{sampleMC}.}
  \item{\code{bcCI}}{Matrix of bias-corrected \code{1 - alpha} confidence
     intervals for MC differences for each pairwise comparison. Preferable
     to \code{simpleCI} when \code{meanDiff} is the best estimate of the MC
     difference. \code{simpleCI} is preferred when
     \code{medianDiff} is a better estimator. When \code{meanDiff==medianDiff},
     these should be identical.  Estimated as the
     \code{pnorm(2 * z0 + qnorm(alpha / 2))} and
     \code{pnorm(2 * z0 + qnorm(1 - alpha / 2))} quantiles of sampled
     differences, where z0 is the proportion of \code{sampleDiff < meanDiff}.}
  \item{\code{sampleDiff}}{Only provided if \code{returnSamples} is TRUE.
     List of sampled values for each pairwise MC difference.}
}
}
\description{
Estimates mean (and median) differences in MC, and includes measures of
uncertainty (SE and CI).  For those measures of uncertainty to be accurate,
only apply this function to MC estimates where all data sources are
independent (e.g., different species).
}
\examples{
\donttest{
data('OVENdata')
ovenPsi <- estTransition(isGL = OVENdata$isGL, #Logical vector:light-level GL(T)
                 isTelemetry = !OVENdata$isGL,
                 geoBias = OVENdata$geo.bias, # Light-level GL location bias
                 geoVCov = OVENdata$geo.vcov, # Location covariance matrix
                 targetSites = OVENdata$targetSites, # Non-breeding target sites
                 originSites = OVENdata$originSites, # Breeding origin sites
                 originPoints = OVENdata$originPoints, # Capture Locations
                 targetPoints = OVENdata$targetPoints, # Device target locations
                 verbose = 0,   # output options
                 nSamples = 100, # This is set low for example
                 resampleProjection = sf::st_crs(OVENdata$targetSites))
ovenEst <- estStrength(targetDist = OVENdata$targetDist, # targetSites distance matrix
                 originDist = OVENdata$originDist, # originSites distance matrix
                 originRelAbund = OVENdata$originRelAbund,#Origin relative abund
                 psi = ovenPsi,
                 verbose = 1,   # output options
                 nSamples = 1000)
fm <- getCMRexample()
originPos13 <- matrix(c(rep(seq(-99, -81, 2), each = 10),
                        rep(seq(49, 31, -2), 10)), 100, 2)
targetPos13 <- matrix(c(rep(seq(-79, -61, 2), each = 10),
                        rep(seq(9, -9, -2), 10)), 100, 2)
originPosCMR <- rowsum(originPos13, c(rep(1:2, 5, each = 5),
                                      rep(3:4, 5, each = 5))) / 25
targetPosCMR <- rowsum(targetPos13, c(rep(1:2, 5, each = 5),
                                      rep(3:4, 5, each = 5))) / 25
originDist <- distFromPos(originPosCMR, 'ellipsoid')
targetDist <- distFromPos(targetPosCMR, 'ellipsoid')
originRelAbundTrue <- rep(0.25, 4)
theorEst <- estStrength(originRelAbund = originRelAbundTrue, psi = fm,
                  originDist = originDist, targetDist = targetDist,
                  originSites = 5:8, targetSites = c(3,2,1,4),
                  nSamples = 1000, verbose = 0,
                  sampleSize = length(grep("[2-5]", fm$data$data$ch)))
ovenEst
theorEst
diff1 <- diffMC(estimates = list(Ovenbird = ovenEst, Theorybird = theorEst),
                nSamples = 10000, returnSamples = TRUE)

}
}
\references{
Cohen, E. B., C. S. Rushing, F. R. Moore, M. T. Hallworth, J. A. Hostetler,
M. Gutierrez Ramirez, and P. P. Marra. 2019. The strength of
migratory connectivity for birds en route to breeding through the Gulf of
Mexico. Ecography 42: 658 - 669.
\doi{10.1111/ecog.03974}
}
