% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{MicrobialGrowth}
\alias{MicrobialGrowth}
\title{MicrobialGrowth regression function}
\usage{
MicrobialGrowth(
  x,
  y,
  model = "gompertz",
  clip = c(-Inf, Inf),
  start = list(),
  lower = list(),
  upper = list(),
  nls.args = list(),
  callbackError = NULL,
  ...
)
}
\arguments{
\item{x}{index series or time series.}

\item{y}{values or list of values to regress (should not be logged).}

\item{model}{wanted growth model : "baranyi", "gompertz" or "rosso".}

\item{clip}{a pair of values indicating in which interval to clip the data \code{y}. When \code{clip} is missing, default values are used.}

\item{start}{a named list of starting estimates. When \code{start} is missing, default values are used.}

\item{lower}{a named list of lower bounds. When \code{lower} is missing, default values are used.}

\item{upper}{a named list of upper bounds. When \code{upper} is missing, default values are used.}

\item{nls.args}{additional parameters to use when calling \link[stats]{nls}.}

\item{callbackError}{function to call on error during regression.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a MicrobialGrowth-object composed of
\item{call}{the matched call with several components.}
\item{coefficients}{coefficients obtained by regression.}
\item{data}{data used for regression, once the y values are clipped}
\item{f}{a list of functions such as \code{formula} to retrieve the function of the model with the coefficients obtained by regression, \code{confint} to retrieve the confidence intervals, etc.}
\item{isValid}{a boolean indicating whether the regression was successful or not.}
\item{message}{contains the error message if the regression fails, \code{NULL} otherwise.}
\item{reg}{the \code{nls} object returned by the \code{nls} function.}
}
\description{
Regression function to different microbial growth models.
}
\details{
Use \code{listAvailableModels()} function to see all values accepted by \code{model} parameter.

The default values for \code{clip}, \code{start}, \code{lower} and \code{upper} are calculated based on the given data. These default values can be known through the \code{call} member of the returned value.

The \code{nls.args} argument is a list that can contain any \link[stats]{nls} function argument except \code{formula}, \code{algorithm}, \code{start}, \code{lower} and \code{upper} which are already fixed (via a homonymous or hard-coded argument).

For the \code{callbackError} argument, prefer the \code{stop} function to block or \code{warning} to not be blocking.
}
\examples{
# Using the embedded data example_data
# Simple example
g <- MicrobialGrowth(example_data$time, example_data$y1, model="gompertz")

# Multiple regression example
G <- MicrobialGrowth(example_data$time, example_data[2:ncol(example_data)], model="gompertz")

# Example of multiple parameter changes
g <- MicrobialGrowth(example_data$time, example_data$y1, model="gompertz",
                           clip = c(0.15, Inf), start = list(N0=0.1, Nmax=2,
                           mu=0.05, lambda=40), lower = list(lambda = 40))

# Example of using `nls.args` to apply weight to some data
g <- MicrobialGrowth(example_data$time, example_data$y1, model="gompertz",
nls.args = list(weights = (function(x){(x >= 50 & x <= 70)*9 + 1})(example_data$time)))

# Example of callbackError (remaining non-blocking)
g <- MicrobialGrowth(example_data$time, example_data$y15, model="gompertz",
                           callbackError = warning)

# Example of callbackError (becoming blocking)
try(
  g <- MicrobialGrowth(c(1,2,3,4,5),c(1,1,1,1,1), model="gompertz", callbackError = stop)
)
}
