% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{init}
\alias{init}
\title{Initialise the membership matrix \eqn{H} or prototype matrix \eqn{W}.}
\usage{
init(
  data = NULL,
  k = NULL,
  method = c("kmeans", "uniform", "dirichlet", "nmf")
)
}
\arguments{
\item{data}{Data matrix or data frame.}

\item{k}{The number of prototypes/clusters.}

\item{method}{Character: 'kmeans', 'uniform', 'dirichlet' or 'nmf'. If there are more than one method,
the default is selecting the first method in the vector.}
}
\value{
Initialised \eqn{H}, \eqn{W} matrix.
}
\description{
This function initialises the \eqn{H_{n \times k}} matrix
or the \eqn{W_{k \times p}} matrix to start the SSMF model.
This function is often used in conjunction with the function ssmf( ). Also, the code can be run separately from the function
ssmf( ). This function returns to simplex-structured soft membership matrix \eqn{H} and prototype matrix \eqn{W}.
}
\details{
'kmeans': create the \eqn{W} matrix using the centres of the kmeans output; create the \eqn{H} matrix by converting the classification into a binary matrix.

'uniform': create the \eqn{H} matrix by sampling the values from uniform distribution and making the rows of the matrix lie in the unit simplex; group the observations with their maximum memberships
and create the \eqn{W} matrix by combining the mean vector in each group.

'dirichlet': create the \eqn{H} matrix by sampling the values from Dirichlet distribution; group the observations with their maximum memberships
and create the \eqn{W} matrix by combining the mean vector in each group.

'nmf': create the \eqn{W} matrix using the matrix of basic components from NMF model; the coefficient matrix is acquired from NMF model,
then the \eqn{H} is created by making the rows of the coefficient matrix lie in the unit simplex.
}
\examples{
# example code
\donttest{
init(data = SimulatedDataset, k = 4, method = 'kmeans')
}
}
\author{
Wenxuan Liu
}
