% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{MetaRVMResults}
\alias{MetaRVMResults}
\title{MetaRVM Results Class}
\description{
R6 class to handle MetaRVM simulation results with comprehensive analysis and visualization methods.
This class stores formatted simulation results and provides methods for data summarization,
subsetting, and visualization with flexible demographic groupings.
}
\details{
The MetaRVMResults class automatically formats raw simulation output upon initialization,
converting time steps to calendar dates and adding demographic attributes. It provides
methods for flexible data summarization across any combination of age, race, and
geographic zone categories, plus method chaining for streamlined analysis workflows.
}
\examples{
\donttest{
options(odin.verbose = FALSE)
example_config <- system.file("extdata", "example_config.yaml", package = "MetaRVM")
# Run simulation
results_obj <- metaRVM(example_config)
# Access formatted results
head(results_obj$results)

# Subset data with multiple filters
subset_data <- results_obj$subset_data(
  age = c("18-49", "50-64"), 
  disease_state = c("H", "D"),
  date_range = c(as.Date("2024-01-01"), as.Date("2024-02-01"))
)

# Method chaining for analysis and visualization
results_obj$subset_data(disease_state = "H")$summarize(
  group_by = c("age", "race"), 
  stats = c("median", "quantile"),
  quantiles = c(0.25, 0.75)
)$plot()
}

}
\author{
Arindam Fadikar
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{config}}{MetaRVMConfig object used to generate these results}

\item{\code{results}}{data.table containing formatted simulation results}

\item{\code{run_info}}{List containing run metadata}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MetaRVMResults-new}{\code{MetaRVMResults$new()}}
\item \href{#method-MetaRVMResults-print}{\code{MetaRVMResults$print()}}
\item \href{#method-MetaRVMResults-subset_data}{\code{MetaRVMResults$subset_data()}}
\item \href{#method-MetaRVMResults-summarize}{\code{MetaRVMResults$summarize()}}
\item \href{#method-MetaRVMResults-clone}{\code{MetaRVMResults$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMResults-new"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMResults-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new MetaRVMResults object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMResults$new(
  raw_results,
  config,
  run_info = NULL,
  formatted_results = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw_results}}{Raw simulation results data.table}

\item{\code{config}}{MetaRVMConfig object used for the simulation}

\item{\code{run_info}}{Optional metadata about the run}

\item{\code{formatted_results}}{formatted simulation results data.table}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New MetaRVMResults object (invisible)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMResults-print"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMResults-print}{}}}
\subsection{Method \code{print()}}{
Print summary of results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMResults$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self (invisible)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMResults-subset_data"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMResults-subset_data}{}}}
\subsection{Method \code{subset_data()}}{
Subset the data based on any combination of parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMResults$subset_data(
  ages = NULL,
  races = NULL,
  zones = NULL,
  disease_states = NULL,
  date_range = NULL,
  instances = NULL,
  exclude_p_columns = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ages}}{Vector of age categories to include (default: all)}

\item{\code{races}}{Vector of race categories to include (default: all)}

\item{\code{zones}}{Vector of zones to include (default: all)}

\item{\code{disease_states}}{Vector of disease states to include (default: all, excludes p_ columns)}

\item{\code{date_range}}{Vector of two dates start_date, and end_date for filtering (default: all)}

\item{\code{instances}}{Vector of instance numbers to include (default: all)}

\item{\code{exclude_p_columns}}{Logical, whether to exclude p_ columns (default: TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
MetaRVMResults object with subset of results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMResults-summarize"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMResults-summarize}{}}}
\subsection{Method \code{summarize()}}{
Summarize results across specified demographic characteristics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMResults$summarize(
  group_by,
  disease_states = NULL,
  date_range = NULL,
  stats = c("mean", "median", "sd"),
  quantiles = c(0.25, 0.75),
  exclude_p_columns = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group_by}}{Vector of demographic variables to group by: c("age", "race", "zone")}

\item{\code{disease_states}}{Vector of disease states to include (default: all, excludes p_ columns)}

\item{\code{date_range}}{Optional date range for filtering}

\item{\code{stats}}{Vector of statistics to calculate: c("mean", "median", "sd", "min", "max", "sum", "quantile"). If NULL, returns all instances}

\item{\code{quantiles}}{Vector of quantiles to calculate if "quantile" is in stats (default: c(0.25, 0.75))}

\item{\code{exclude_p_columns}}{Logical, whether to exclude p_ columns (default: TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.table with summarized time series data or all instances if stats = NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMResults-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMResults-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMResults$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
