% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMeasurementSummary.R
\name{plotMeasurementSummary}
\alias{plotMeasurementSummary}
\title{Plot summariseMeasurementTiming results.}
\usage{
plotMeasurementSummary(
  result,
  x = "codelist_name",
  y = "days_between_measurements",
  plotType = "boxplot",
  facet = visOmopResults::strataColumns(result),
  colour = c("codelist_name"),
  style = NULL
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{x}{Variable to plot on the x axis when plotType is "boxlot" or "barplot".}

\item{y}{Variable to plot, it can be "days_between_measurements" or
"measurements_per_subject".}

\item{plotType}{Type of plot, either "boxplot", "barplot", or "densityplot".}

\item{facet}{Columns to facet by. See options with
`visOmopResults::plotColumns(result)`. Formula input is also allowed to
specify rows and columns.}

\item{colour}{Columns to color by. See options with
`visOmopResults::plotColumns(result)`.}

\item{style}{Pre-defined style to apply: "default" or
"darwin" - the latter just for gt and flextable. If NULL the "default" style
is used.}
}
\value{
A ggplot.
}
\description{
Plot summariseMeasurementTiming results.
}
\examples{
\donttest{
library(MeasurementDiagnostics)
library(dplyr)

cdm <- mockMeasurementDiagnostics()

result <- summariseMeasurementUse(
  cdm = cdm,
  codes = list("test_codelist" = c(3001467L, 45875977L))
)

result |>
  filter(variable_name == "days_between_measurements") |>
  plotMeasurementSummary()

CDMConnector::cdmDisconnect(cdm)
}
}
