#' Shifted Matrix Transformation
#'
#' This function modifies the shape of a model weights matrix by shifting its elements.
#'
#' @param mat A numeric matrix to be transformed.
#' @return A shifted version of the input matrix.
#' @export
shift_matrix <- function(mat) {
  # Create a copy of the original matrix
  shifted_mat <- mat

  # Iterate over each row
  for (i in 2:(nrow(mat))) {
    # Extract the elements to be shifted (row)
    to_shift <- shifted_mat[i, ]

    # Shift the elements in the row
    shifted_mat[i, ] <- c(to_shift[-1], shifted_mat[(i)])
  }

  return(shifted_mat)
}
