% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_bigten_c.R
\name{scale_colour_bigten_c}
\alias{scale_colour_bigten_c}
\title{Plotting with Big Ten palettes for colour ggplot2 (British spelling)}
\usage{
scale_colour_bigten_c(palette = "primary", direction = 1, ...)
}
\arguments{
\item{palette}{Type of palette: "primary" or "secondary"}

\item{direction}{Sets order of colors. Default is 1. If direction is -1,
palette color order is reversed}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{scale_color_gradientn}}}
}
\value{
A ggproto object defining a continuous colour scale for use with ggplot2.
}
\description{
Plotting with Big Ten palettes for colour ggplot2 (British spelling)
}
\examples{
library(ggplot2)
ggplot(data = mtcars, aes(x = mpg, y = disp, colour = wt)) +
  geom_point() +
  scale_colour_bigten_c(palette = "primary")
}
