% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htest_LRTest.R
\name{LR_samp_dist_par}
\alias{LR_samp_dist_par}
\title{Monte Carlo Likelihood Ratio Test sample distribution (parallel version)}
\usage{
LR_samp_dist_par(
  mdl_h0,
  k1,
  N,
  burnin,
  Z,
  mdl_h0_control,
  mdl_h1_control,
  workers
)
}
\arguments{
\item{mdl_h0}{List with restricted model properties.}

\item{k1}{integer specifying the number of regimes under the alternative hypothesis.}

\item{N}{integer specifying the number of replications.}

\item{burnin}{integer specifying the number of observations to drop from beginning of simulation.}

\item{mdl_h0_control}{List with controls/options used to estimate restricted model.}

\item{mdl_h1_control}{List with controls/options used to estimate unrestricted model.}

\item{workers}{Integer determining the number of workers to use for parallel computing version of test. Note that parallel pool must already be open.}
}
\value{
vector of simulated LRT statistics
}
\description{
This function simulates the sample distribution under the null hypothesis using a parallel pool.
}
\references{
Rodriguez-Rondon, Gabriel and Jean-Marie Dufour. 2022. "Simulation-Based Inference for Markov Switching Models” \emph{JSM Proceedings, Business and Economic Statistics Section: American Statistical Association}.

Rodriguez-Rondon, Gabriel and Jean-Marie Dufour. 2023. “Monte Carlo Likelihood Ratio Tests for Markov Switching Models.” \emph{Unpublished manuscript}.
}
\keyword{internal}
