% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeOfBlobs.R
\name{treeFromSplits}
\alias{treeFromSplits}
\title{Produce tree from compatible splits}
\usage{
treeFromSplits(sp, plot = FALSE)
}
\arguments{
\item{sp}{a compatible split system, as produced by compatibleSplits}

\item{plot, }{a logical, if TRUE, plot tree}
}
\value{
a phylo object for tree displaying splits
}
\description{
Produce tree from compatible splits
}
\examples{
data(pTableYeastRokas)
dist=NANUQdist(pTableYeastRokas, alpha=.05, beta=.95,outfile=NULL)
nn=neighborNet(dist)
plot(nn,"2D")
tob=treeFromSplits(compatibleSplits(nn$splits),plot=TRUE) #produce tree of blobs of splits graph

}
\seealso{
\code{\link{compatibleSplits}, \link{TINNIK}}
}
