% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics}
\alias{metrics}
\alias{binary_sens}
\alias{binary_spec}
\alias{binormal_auc}
\alias{binormal_eu}
\alias{binormal_sens}
\alias{binormal_spec}
\alias{binormalLR_auc}
\alias{binormalLR_eu}
\alias{binormalLR_sens}
\alias{binormalLR_spec}
\alias{empirical_auc}
\alias{empirical_eu}
\alias{empirical_sens}
\alias{empirical_spec}
\alias{trapezoidal_auc}
\alias{trapezoidal_sens}
\alias{trapezoidal_spec}
\title{Performance Metrics}
\usage{
binary_sens(truth, rating)

binary_spec(truth, rating)

binormal_auc(
  truth,
  rating,
  partial = FALSE,
  min = 0,
  max = 1,
  normalize = FALSE
)

binormal_eu(truth, rating, slope = 1)

binormal_sens(truth, rating, spec)

binormal_spec(truth, rating, sens)

binormalLR_auc(
  truth,
  rating,
  partial = FALSE,
  min = 0,
  max = 1,
  normalize = FALSE
)

binormalLR_eu(truth, rating, slope = 1)

binormalLR_sens(truth, rating, spec)

binormalLR_spec(truth, rating, sens)

empirical_auc(
  truth,
  rating,
  partial = FALSE,
  min = 0,
  max = 1,
  normalize = FALSE
)

empirical_eu(truth, rating, slope = 1)

empirical_sens(truth, rating, spec)

empirical_spec(truth, rating, sens)

trapezoidal_auc(
  truth,
  rating,
  partial = FALSE,
  min = 0,
  max = 1,
  normalize = FALSE
)

trapezoidal_sens(truth, rating, spec)

trapezoidal_spec(truth, rating, sens)
}
\arguments{
\item{truth}{vector of true binary statuses.}

\item{rating}{vector of 0-1 binary ratings for the binary metrics and ranges
of numeric ratings for the others.}

\item{partial}{character string \code{"sensitivity"} or \code{"specificity"}
for calculation of partial AUC, or \code{FALSE} for full AUC.  Partial
matching of the character strings is allowed.  \code{"specificity"}
results in area under the ROC curve between the given \code{min} and
\code{max} specificity values, whereas \code{"sensitivity"} results in area to
the right of the curve between the given sensitivity values.}

\item{min, max}{minimum and maximum sensitivity or specificity values over
which to calculate partial AUC.}

\item{normalize}{logical indicating whether partial AUC is divided by the
interval width (\code{max - min}) over which it is calculated.}

\item{slope}{slope of the iso-utility line at which to compute expected
utility of the ROC curve.}

\item{sens, spec}{numeric sensitivity/specificity at which to calculate
specificity/sensitivity.}
}
\value{
Returns a numeric value.
}
\description{
Estimated performance metrics from ROC curves.
}
\details{
Performance metrics measure the degree to which higher case ratings are
associated with positive case statuses, where positive status is taken to be
the highest level of \code{truth}.  Available metrics include area under the
ROC curve (auc), expected utility of the ROC curve (eu) at a given
iso-utility line (Abbey, 2013), sensitivity (sens) at a given specificity,
and specificity (spec) at a given sensitivity.
}
\references{
Abbey CK, Samuelson FW and Gallas BD (2013). Statistical power considerations
for a utility endpoint in observer performance studies. Academic Radiology,
20: 798-806.
}
\seealso{
\code{\link{mrmc}}, \code{\link{srmc}}, \code{\link{stmc}}
}
