% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_chi_sq.R
\name{v_chi_sq}
\alias{v_chi_sq}
\alias{v.chi.sq}
\title{V for Chi-Square}
\usage{
v_chi_sq(x2, n, r, c, a = 0.05)

v.chi.sq(x2, n, r, c, a = 0.05)
}
\arguments{
\item{x2}{chi-square statistic}

\item{n}{sample size}

\item{r}{number of rows in the contingency table}

\item{c}{number of columns in the contingency table}

\item{a}{significance level}
}
\value{
\describe{
  \item{v}{\eqn{V} statistic}
  \item{vlow}{lower level confidence interval of \eqn{V}}
  \item{vhigh}{upper level confidence interval of \eqn{V}}
  \item{n}{sample size}
  \item{df}{degrees of freedom}
  \item{x2}{\eqn{\chi^2} statistic}
  \item{p}{p-value}
  \item{estimate}{the \eqn{V} statistic and confidence interval
in APA style for markdown printing}
  \item{statistic}{the \eqn{\chi^2} statistic in APA style for
markdown printing}
}
}
\description{
This function displays \eqn{V} and its non-central confidence interval
for the specified \eqn{\chi^2} statistic.
}
\details{
\eqn{V} is calculated by finding the square root of \eqn{\chi^2}
divided by the product of the sample size and the smaller of the
two degrees of freedom.

\deqn{V = \sqrt{\frac{\chi^2}{n \times df_{\mathrm{small}}}}}

\href{https://www.aggieerin.com/shiny-server/tests/chiv.html}{Learn more on our example page.}

**Note on function and output names:** This effect size is now implemented
with the snake_case function name `v_chi_sq()` to follow modern R style
guidelines. The original dotted version `v.chi.sq()` is still available as
a wrapper for backward compatibility, and both functions return the same
list. The returned object includes both the original element names (e.g.,
`v`, `vlow`, `vhigh`, `n`, `df`, `x2`, `p`, `estimate`, `statistic`) and
newer snake_case aliases (e.g., `v_value`, `v_lower_limit`, `v_upper_limit`,
`sample_size`, `df_total`, `chi_square`, `p_value`). New code should prefer
`v_chi_sq()` and the snake_case output names, but existing code using the
older names will continue to work.
}
\examples{

# The following example is derived from the "chisq_data"
# dataset, included in the MOTE library.

# Individuals were polled about their number of friends (low, medium, high)
# and their number of kids (1, 2, 3+) to determine if there was a
# relationship between friend groups and number of children, as we
# might expect that those with more children may have less time for
# friendship maintaining activities.

chisq.test(chisq_data$kids, chisq_data$friends)

v_chi_sq(x2 = 2.0496, n = 60, r = 3, c = 3, a = .05)

# Backwards-compatible dotted name (deprecated)
v.chi.sq(x2 = 2.0496, n = 60, r = 3, c = 3, a = .05)

}
\keyword{chi-square}
\keyword{effect}
\keyword{size}
