% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta_f.R
\name{eta_f}
\alias{eta_f}
\alias{eta.F}
\title{\eqn{\eta^2} and Coefficient of Determination (R\eqn{^2})
for ANOVA from \eqn{F}}
\usage{
eta_f(dfm, dfe, f_value, a = 0.05, Fvalue)

eta.F(dfm, dfe, Fvalue, a = 0.05)
}
\arguments{
\item{dfm}{degrees of freedom for the model/IV/between}

\item{dfe}{degrees of freedom for the error/residual/within}

\item{f_value}{F statistic}

\item{a}{significance level}

\item{Fvalue}{F statistic only for older function}
}
\value{
Provides the effect size (\eqn{\eta^2}) with associated
confidence intervals and relevant statistics.

\describe{
\item{eta}{\eqn{\eta^2} effect size}
\item{etalow}{lower level confidence interval of \eqn{\eta^2}}
\item{etahigh}{upper level confidence interval of \eqn{\eta^2}}
\item{dfm}{degrees of freedom for the model/IV/between}
\item{dfe}{degrees of freedom for the error/residual/within}
\item{F}{\eqn{F}-statistic}
\item{p}{p-value}
\item{estimate}{the \eqn{\eta^2} statistic and confidence interval
in APA style for markdown printing}
\item{statistic}{the \eqn{F}-statistic in APA style for markdown printing}
}
}
\description{
**Note on function and output names:** This effect size is now implemented
with the snake_case function name `eta_f()` to follow modern R style
guidelines. The original dotted version `eta.F()` is still available as a
wrapper for backward compatibility, and both functions return the same
list. The returned object includes both the original element names
(e.g., `eta`, `etalow`, `etahigh`, `dfm`, `dfe`, `F`, `p`, `estimate`,
`statistic`) and newer snake_case aliases (e.g., `eta_value`,
`eta_lower_limit`, `eta_upper_limit`, `df_model`, `df_error`, `f_value`,
`p_value`). New code should prefer `eta_f()` and the snake_case output
names, but existing code using the older names will continue to work.
}
\details{
This function displays \eqn{\eta^2} from ANOVA analyses
and their non-central confidence interval based on the \eqn{F} distribution.
These values are calculated directly from F statistics and can be used
for between subjects and repeated measures designs.
Remember if you have two or more IVs, these values are partial eta squared.

Eta is calculated by multiplying the degrees of freedom of
the model by the F-statistic. This is divided by the product
of degrees of freedom of the model, the F-statistic, and
the degrees of freedom for the error or residual.

\deqn{\eta^2 = \frac{df_m \cdot F}{df_m \cdot F + df_e}}

\href{https://www.aggieerin.com/shiny-server/tests/etaf.html}{Learn more on our example page.}
}
\examples{

# The following example is derived from the "bn1_data"
# dataset, included in the MOTE library.

# A health psychologist recorded the number of close inter-personal
# attachments of 45-year-olds who were in excellent, fair, or poor
# health. People in the Excellent Health group had 4, 3, 2, and 3
# close attachments; people in the Fair Health group had 3, 5,
# and 8 close attachments; and people in the Poor Health group
# had 3, 1, 0, and 2 close attachments.

anova_model <- lm(formula = friends ~ group, data = bn1_data)
summary.aov(anova_model)

eta_f(dfm = 2, dfe = 8,
      Fvalue = 5.134, a = .05)

# Backwards-compatible dotted name (deprecated)
eta.F(dfm = 2, dfe = 8,
      Fvalue = 5.134, a = .05)
}
\keyword{ANOVA}
\keyword{effect}
\keyword{eta}
\keyword{size}
