% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_z_z.R
\name{d_z_z}
\alias{d_z_z}
\alias{d.z.z}
\title{Cohen's d from z-statistic for Z-test}
\usage{
d_z_z(z, n, a = 0.05, sig = NA)

d.z.z(z, sig = NA, n, a = 0.05)
}
\arguments{
\item{z}{z-statistic from a Z-test.}

\item{n}{Sample size.}

\item{a}{Significance level (alpha) for the confidence interval.
Must be in (0, 1).}

\item{sig}{Population standard deviation (\eqn{\sigma}). This value is
retained for descriptive purposes but is not required to compute the
confidence interval for \eqn{d}.}
}
\value{
A list with the following elements:
\describe{
  \item{d}{Effect size.}
  \item{dlow}{Lower confidence interval bound for \eqn{d}.}
  \item{dhigh}{Upper confidence interval bound for \eqn{d}.}
  \item{sigma}{Population standard deviation (\eqn{\sigma}).}
  \item{z}{z-statistic.}
  \item{p}{Two-tailed p-value.}
  \item{n}{Sample size.}
  \item{estimate}{The \eqn{d} statistic and confidence interval in
APA style for markdown printing.}
  \item{statistic}{The Z-statistic in APA style for markdown printing.}
}
}
\description{
Compute Cohen's \eqn{d} from a z-statistic for a Z-test.
}
\details{
The effect size is computed as:
\deqn{d = \frac{z}{\sqrt{n}},}
where \eqn{n} is the sample size.

The confidence interval bounds assume a normal-theory standard error for
\eqn{d} of \eqn{1 / \sqrt{n}} (given that \eqn{d = z / \sqrt{n}}). Thus:
\deqn{d_{\mathrm{low}} = d - z_{\alpha/2} \cdot 1/\sqrt{n}}
\deqn{d_{\mathrm{high}} = d + z_{\alpha/2} \cdot 1/\sqrt{n}}
where \eqn{z_{\alpha/2}} is the critical value from the standard normal
distribution.

The population standard deviation (\eqn{\sigma}) is retained for descriptive
purposes but is not required for computing confidence intervals for \eqn{d}.

See the online example for additional context:
\href{https://www.aggieerin.com/shiny-server/tests/zz.html}{Learn more on our example page.}
}
\examples{

# A recent study suggested that students (N = 100) learning
# statistics improved their test scores with the use of
# visual aids (Z = 2.5). The population standard deviation is 4.

# You can type in the numbers directly as shown below,
# or refer to your dataset within the function.

    d_z_z(z = 2.5, sig = 4, n = 100, a = .05)

    d_z_z(z = 2.5, n = 100, a = .05)

    d.z.z(2.5, 4, 100, .05)
}
\keyword{effect}
\keyword{size}
\keyword{z-test}
