% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_single_t_t.R
\name{d_single_t_t}
\alias{d_single_t_t}
\alias{d.single.t.t}
\title{Cohen's d from t for One-Sample t-Test}
\usage{
d_single_t_t(t, n, a = 0.05)

d.single.t.t(t, n, a = 0.05)
}
\arguments{
\item{t}{t-test value.}

\item{n}{Sample size.}

\item{a}{Significance level (alpha) for the confidence interval.
Must be in (0, 1).}
}
\value{
A list with the following elements:
\describe{
  \item{d}{Cohen's \eqn{d}.}
  \item{dlow}{Lower limit of the \eqn{(1-\alpha)} confidence
interval for \eqn{d}.}
  \item{dhigh}{Upper limit of the \eqn{(1-\alpha)} confidence
interval for \eqn{d}.}
  \item{n}{Sample size.}
  \item{df}{Degrees of freedom (\eqn{n - 1}).}
  \item{t}{t-statistic.}
  \item{p}{p-value.}
  \item{estimate}{APA-style formatted string for reporting
\eqn{d} and its CI.}
  \item{statistic}{APA-style formatted string for reporting
the t-statistic and p-value.}
}
}
\description{
Compute Cohen's \eqn{d} and a noncentral-t confidence interval for a
one-sample (single) t-test using the observed t-statistic.
}
\details{
The effect size is calculated as:
\deqn{d = \frac{t}{\sqrt{n}},}
where \eqn{t} is the one-sample t-statistic and \eqn{n} is the sample size.

The corresponding \eqn{(1 - \alpha)} confidence interval for \eqn{d} is
derived from the noncentral t distribution.

See the online example for additional context:
\href{https://www.aggieerin.com/shiny-server/tests/singlett.html}{Learn more on our example page.}
}
\examples{
# A school has a gifted/honors program that they claim is
# significantly better than others in the country. The gifted/honors
# students in this school scored an average of 1370 on the SAT,
# with a standard deviation of 112.7, while the national average
# for gifted programs is a SAT score of 1080.

    gift <- t.test(singt_data$SATscore, mu = 1080, alternative = "two.sided")

# Direct entry of t-statistic and sample size:
    d_single_t_t(9.968, 15, .05)

# Equivalent shorthand:
    d_single_t_t(9.968, 15, .05)

# Using values from a t-test object and dataset:
    d_single_t_t(gift$statistic, length(singt_data$SATscore), .05)
}
\keyword{effect}
\keyword{one-sample}
\keyword{single}
\keyword{size}
\keyword{t}
