#' Repeated Measures One-Way ANOVA Example Data
#'
#' @description
#' Example data for a repeated measures one-way ANOVA examining whether
#' pulse rate differs across stimulus types. Participants were exposed to
#' three categories of images: neutral (e.g., household objects like a toaster),
#' positive (e.g., puppies, babies), and negative (e.g., mutilated faces,
#' scenes of war). Pulse rate was measured for each participant under each
#' condition. Designed for use with \code{\link{omega.F}}.
#'
#' @docType data
#'
#' @usage data(rm1_data)
#'
#' @format A data frame with 3 variables:
#' \describe{
#'   \item{neutral}{Numeric. Pulse rate during exposure to neutral stimuli.}
#'   \item{positive}{Numeric. Pulse rate during exposure to positive stimuli.}
#'   \item{negative}{Numeric. Pulse rate during exposure to negative stimuli.}
#' }
#'
#' @keywords datasets
#'
#'
"rm1_data"
