% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria.values.mse.R
\name{criteria.values.mse}
\alias{criteria.values.mse}
\title{Evaluating individual criteria of the designs}
\usage{
criteria.values.mse(search.obj, mood.obj, eps = 10^-20, Biter = 1000)
}
\arguments{
\item{search.obj}{Output of the `Search' function}

\item{mood.obj}{Output of the `mood' function}

\item{eps}{Computational tolerance, default 10^-20}

\item{Biter}{MC sample size for evaluating the mse(D)-component}
}
\value{
List of the calculated values:
\itemize{
\item \code{df} pure error degrees of freedom
\item \code{Ds} Ds-criterion value, intercept excluded
\item \code{DP} DPs-criterion value, intercept excluded
\item \code{LoFDP} LoF(DP)-criterion value
\item \code{mseD} mse(D)-criterion value, obtained via MC sampling
\item \code{mseP} mse(D)-criterion value, obtained using point prior
\item \code{L} L-criterion value, intercept excluded
\item \code{LP} LP-criterion value, intercept excluded
\item \code{LoFLP} LoF(LP)-criterion value
\item \code{mseL} mse(L)-criterion value
}
}
\description{
Calculating values of determinant- and trace-based components of
MSE(D)- and MSE(L)- criteria for an output of a search object,
with model and control parameters set in a mood object.
}
