% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbinom.est.R
\name{nbinom_est}
\alias{nbinom_est}
\title{Method of Moments Estimation of Negative Binomial distribution}
\usage{
nbinom_est(
  data,
  size.known = FALSE,
  size = NULL,
  plot = TRUE,
  curvecol = "red",
  ...
)
}
\arguments{
\item{data}{A numeric vector.}

\item{size.known}{logical indicating whether the size of the binomial distribution is known or not.}

\item{size}{integer valued parameter of binomial distribution.}

\item{plot}{logical which controls whether the barplot of the data along with the probability curve of the theoretical negative binomial distribution with the estimated parameters.}

\item{curvecol}{color of the theoretical probability curve}

\item{...}{additional plotting parameters}
}
\value{
the estimated parameters by the method of moments of the data assuming the underlying distribution is negative binomial distribution
}
\description{
function to get the method of moment estimate(s) of negative binomial distribution
}
\examples{
nbinom_est(rnbinom(1000,size=5,prob=0.2),size.known=TRUE,size=5)#no of successes known
nbinom_est(rnbinom(1000,size=10,prob=0.6))
}
