#'Method of Moments Estimation of Negative Binomial distribution
#'@description function to get the method of moment estimate(s) of negative binomial distribution
#'@param data A numeric vector.
#'@param size.known logical indicating whether the size of the binomial distribution is known or not.
#'@param size	integer valued parameter of binomial distribution.
#'@param plot logical which controls whether the barplot of the data along with the probability curve of the theoretical negative binomial distribution with the estimated parameters.
#'@param curvecol color of the theoretical probability curve
#'@param ... additional plotting parameters
#'@importFrom stats dnbinom var
#'@importFrom graphics hist curve
#'@return the estimated parameters by the method of moments of the data assuming the underlying distribution is negative binomial distribution
#'@examples
#'nbinom_est(rnbinom(1000,size=5,prob=0.2),size.known=TRUE,size=5)#no of successes known
#'nbinom_est(rnbinom(1000,size=10,prob=0.6))
#'@export
nbinom_est=function(data,size.known=FALSE,size=NULL,plot=TRUE,curvecol="red",...)
{
  avg=mean(data)
  va.r=var(data)
  if(size.known==FALSE) size=(avg/((va.r/avg)-1))
  p=avg/va.r
  s=round(size)
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dnbinom(x,size=s,prob=p),from=0,to=floor(max(data)),n=floor(max(data))+1,add=T,col=curvecol)
  }
  output=list(round(size),p)
  names(output)=c("size","prob")
  return(output)
}
