% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixPV.R
\name{mixPV}
\alias{mixPV}
\title{Fit Weighted Multilevel Models Using Plausible Values}
\usage{
mixPV(fml, data = NULL, mc = FALSE, silent = FALSE, ...)
}
\arguments{
\item{fml}{The model formula. Multiple plausible values are specified using the form: \code{pv1 + pv2 + pv3 ~ x1} (depending how many PVs are present).}

\item{data}{Merged dataset to analyze (containing variables at different levels).}

\item{mc}{Option to use multiple cores to speed up processing (set to FALSE by default).}

\item{silent}{Option to show which plausible value is being analyzed (set to FALSE by default).}

\item{...}{Options that are used by the mix function in the WeMix package.}
}
\value{
A list object of \code{mix} results. Results are pooled using the summary function.
}
\description{
Helper function to fit multilevel models with plausible values
using weights at different levels using the mix function from the WeMix package (Bailey et al., 2023): see https://cran.r-project.org/web/packages/WeMix/WeMix.pdf.
}
\examples{
\dontrun{
data(pisa2012, package = 'MLMusingR')
m1 <- mixPV(pv1math + pv2math + pv3math + pv4math + pv5math ~ escs + (1|schoolid),
weights = c('w_fstuwt', 'w_fschwt'), data = pisa2012)
summary(m1)
}
}
\references{
\cite{Huang, F. (2024). Using plausible values when fitting multilevel models with large-scale assessment data using R. Large-scale Assessments in Education, 12(7).
(\href{https://largescaleassessmentsineducation.springeropen.com/articles/10.1186/s40536-024-00192-0}{link})}
}
\author{
Francis Huang, \email{huangf@missouri.edu}
}
