% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-KillerRescue.R
\name{cubeKillerRescue}
\alias{cubeKillerRescue}
\title{Inheritance Cube: Killer-Rescue System}
\usage{
cubeKillerRescue(
  eR = 0,
  Keff = 1,
  Aeff = 1,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{eR}{Conversion of K allele to R allele, a basal mutation rate}

\item{Keff}{Toxin efficacy}

\item{Aeff}{Antidote efficacy}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an inheritance cube to model a Killer-Rescue system.
Killer-Rescue is a 2-locus system: one locus has a toxin and the other locus contains
the antidote. The loci are assumed independent and are non-homing. \cr
This drive has 3 alleles at locus 1 and 2 alleles and locus 2:
\itemize{
\item Locus 1
\itemize{
\item T: Wild-type allele
\item K: "Killer" toxin allele
\item R: Broken toxin allele
}
\item Locus 2
\itemize{
\item W: Wild-type allele
\item A: Antidote allele
}
}
}
