% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-ImmunizingReversalX.R
\name{cubeImmunizingReversalX}
\alias{cubeImmunizingReversalX}
\title{Inheritance Cube: Immunizing Reversal}
\usage{
cubeImmunizingReversalX(
  cHW = 1,
  cEW = 1,
  cEH = 1,
  chHW = 0,
  crHW = 0,
  ceEW = 0,
  crEW = 0,
  ceEH = 0,
  crEH = 0,
  dHW = 0,
  dEW = 0,
  dEH = 0,
  dhHW = 0,
  drHW = 0,
  deEW = 0,
  drEW = 0,
  deEH = 0,
  drEH = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cHW}{Cutting efficiency of H into W}

\item{cEW}{Cutting efficiency of E into W}

\item{cEH}{Cutting efficiency of E into H}

\item{chHW}{Homing efficiency of H at W}

\item{crHW}{Resistance generation efficiency of H at W}

\item{ceEW}{Homing efficiency of E at W}

\item{crEW}{Resistance generation efficiency of E at W}

\item{ceEH}{Homing efficiency of E at H}

\item{crEH}{Resistance efficiency of E at H}

\item{dHW}{H deposition efficiency against W}

\item{dEW}{E deposition efficiency against W}

\item{dEH}{E deposition efficiency against H}

\item{dhHW}{H deposition homing efficiency against W}

\item{drHW}{H deposition resistance efficiency against W}

\item{deEW}{E deposition homing efficiency against W}

\item{drEW}{E deposition resistance efficiency against W}

\item{deEH}{E deposition homing efficiency against H}

\item{drEH}{E deposition resistance efficiency against H}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an Immunizing Reversal construct, it has 5 alleles at 1 locus
\itemize{
\item W: Wild-type
\item H: Homing allele
\item E: Eraser allele
\item R: No-cost resistance allele
\item B: Detrimental resistance allele
}
}
\details{
This is the general form for an immunizing reversal drive. If the c_EW and d_EW,
parameters are all 0, then this simplifies to a basic reversal drive.
This drive represents an X-linked IR drive.
}
