% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-ImmunizingReversalMF.R
\name{cubeImmunizingReversalMF}
\alias{cubeImmunizingReversalMF}
\title{Inheritance Cube: Immunizing Reversal/Basic Reversal}
\usage{
cubeImmunizingReversalMF(
  cHWM = 1,
  cHWF = 1,
  cEWM = 1,
  cEWF = 1,
  cEHM = 1,
  cEHF = 1,
  chHWM = 0,
  chHWF = 0,
  crHWM = 0,
  crHWF = 0,
  ceEWM = 0,
  ceEWF = 0,
  crEWM = 0,
  crEWF = 0,
  ceEHM = 0,
  ceEHF = 0,
  crEHM = 0,
  crEHF = 0,
  dHW = 0,
  dEW = 0,
  dEH = 0,
  dhHW = 0,
  drHW = 0,
  deEW = 0,
  drEW = 0,
  deEH = 0,
  drEH = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cHWM}{Cutting efficiency of H into W in males}

\item{cHWF}{Cutting efficiency of H into W in females}

\item{cEWM}{Cutting efficiency of E into W in males}

\item{cEWF}{Cutting efficiency of E into W in females}

\item{cEHM}{Cutting efficiency of E into H in males}

\item{cEHF}{Cutting efficiency of E into H in females}

\item{chHWM}{Homing efficiency of H into W in males}

\item{chHWF}{Homing efficiency of H into W in females}

\item{crHWM}{Resistance efficiency of H into W in males}

\item{crHWF}{Resistance efficiency of H into W in females}

\item{ceEWM}{Homing efficiency of E into W in males}

\item{ceEWF}{Homing efficiency of E into W in females}

\item{crEWM}{Resistance efficiency of E into W in males}

\item{crEWF}{Resistance efficiency of E into W in females}

\item{ceEHM}{Homing efficiency of E into H in males}

\item{ceEHF}{Homing efficiency of E into H in females}

\item{crEHM}{Resistance efficiency of E into H in males}

\item{crEHF}{Resistance efficiency of E into H in females}

\item{dHW}{Deposition cutting efficiency of H into W}

\item{dEW}{Deposition cutting efficiency of E in to W}

\item{dEH}{Deposition cutting efficiency of E into H}

\item{dhHW}{Deposition homing efficiency of H into W}

\item{drHW}{Deposition resistance efficiency of H into W}

\item{deEW}{Deposition homing efficiency of E into W}

\item{drEW}{Deposition resistance efficiency of E into W}

\item{deEH}{Deposition homing efficiency of E into H}

\item{drEH}{Deposition resistance efficiency of E into H}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an Immunizing Reversal construct, it has 5 alleles at 1 locus
\itemize{
\item W: Wild-type
\item H: Homing allele
\item E: Eraser allele
\item R: No-cost resistance allele
\item B: Detrimental resistance allele
}
}
\details{
This is the general form for an immunizing reversal drive. If the \emph{EW} terms are 0,
then this simplifies to a basic reversal drive.This drive handles different
male and female homing rates, and female deposition from each allele,
signifying differential expression from an autosome.
}
