% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_test_adjusted_pvalue.R
\name{gof_test_adjusted_pvalue}
\alias{gof_test_adjusted_pvalue}
\title{Adjusted p values}
\usage{
gof_test_adjusted_pvalue(
  x,
  pnull,
  rnull,
  phat = function(x) -99,
  dnull = function(x) -99,
  B = c(5000, 1000),
  nbins = c(5, 5),
  minexpcount = 5,
  Ranges = matrix(c(-Inf, Inf, -Inf, Inf), 2, 2),
  SuppressMessages = FALSE,
  maxProcessor,
  doMethods
)
}
\arguments{
\item{x}{matrix with data}

\item{pnull}{cdf under the null hypothesis}

\item{rnull}{routine to generate data under the null hypothesis}

\item{phat}{=function(x) -99, function to estimate parameters from the data, or -99 if no parameters are estimated}

\item{dnull}{=function(x) -99, density function under the null hypothesis, if available, or -99 if missing}

\item{B}{=c(5000, 1000), number of simulation runs for permutation test and for estimation
of the empirical distribution function.}

\item{nbins}{=c(5, 5), number of bins for chi square tests (2D only).}

\item{minexpcount}{= 5, minimum required expected counts for chi-square tests.}

\item{Ranges}{=matrix(c(-Inf, Inf, -Inf, Inf),2,2) a 2x2 matrix with lower and upper bounds.}

\item{SuppressMessages}{= FALSE, show informative messages?}

\item{maxProcessor}{number of cores for parallel processing.}

\item{doMethods}{Which methods should be included? If missing a small number of methods that generally have good power are used.}
}
\value{
a vector of p values.
}
\description{
This function runs a number of goodness-f-fit tests using Rcpp and parallel computing and then finds the correct p value for the combined tests.
}
\details{
For details consult the vignette("MDgof","MDgof")
}
\examples{
# All examples are run with B=10 and maxProcessor=1 to pass CRAN checks.
# This is obviously MUCH TO SMALL for any real usage.
# Tests to see whether data comes from a bivariate standard normal distribution, 
# without parameter estimation.
rnull=function() mvtnorm::rmvnorm(100, c(0, 0))
x=rnull()
pnull=function(x) {
  if(!is.matrix(x)) return(mvtnorm::pmvnorm(rep(-Inf, 2), x))
  apply(x, 1, function(x) mvtnorm::pmvnorm(rep(-Inf, 2), x))
}
dnull=function(x) {
  if(!is.matrix(x)) return(mvtnorm::dmvnorm(x))
  apply(x, 1, function(x) mvtnorm::dmvnorm(x))
}
gof_test_adjusted_pvalue(x, pnull, rnull, dnull=dnull, B=10, maxProcessor = 1)
}
