% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeR.reg.R
\name{computeR.reg}
\alias{computeR.reg}
\title{A function computing the regularised incompatibility index for collections of correlation matrices.}
\usage{
computeR.reg(patterns = list(), SigmaS = list(), alpha)
}
\arguments{
\item{patterns}{A vector with all the patterns in \eqn{\mathbb{S}}}

\item{SigmaS}{The sequence of correlation matrices \eqn{\Sigma_\mathbb{S}}}

\item{alpha}{The regularisation parameter, which satisfies alpha = 1/z.}
}
\value{
The value of \eqn{R_z()}, in the interval \eqn{[0,1]}.

The optimal \eqn{X_\mathbb{S}} for the primal problem.

The sequence of matrices \eqn{X_\mathbb{S}^{0}} as defined in \insertCite{BB2024;textual}{MCARtest}.

The optimal \eqn{\Sigma} for the dual problem.

The sequence of correlation matrices \eqn{\Sigma_\mathbb{S}} in input.
}
\description{
A function solving a SDP problem to compute the regularised incompatibility index \eqn{R_z()} 
for a collection of correlation matrices, as defined in (7) in \insertCite{BB2024;textual}{MCARtest}.
Writes the SDP problem in standard primal form, and uses \code{csdp} to solve this.
}
\examples{
d = 3

SigmaS=list() #Random 2x2 correlation matrices (necessarily consistent)
for(j in 1:d){
x=runif(2,min=-1,max=1); y=runif(2,min=-1,max=1)
SigmaS[[j]]=cov2cor(x\%*\%t(x) + y\%*\%t(y))
}

c = 1
for(i in 1:d){
cand = min(eigen(SigmaS[[i]])$values)
if (cand < c){
  c = cand
 }
}

computeR.reg(list(c(1,2),c(2,3), c(1,3)), SigmaS = SigmaS, alpha = 1/c)$R
computeR.reg(list(c(1,2),c(2,3), c(1,3)), SigmaS = SigmaS, alpha = 2)$R
}
\references{
\insertRef{BB2024}{MCARtest}
}
