% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-ObservationCounts.R
\name{plot_mean_response_2D}
\alias{plot_mean_response_2D}
\title{Plot mean of a response variable across two dimensions, optionally stratified}
\usage{
plot_mean_response_2D(
  data,
  response,
  x,
  y,
  stratify_by = NULL,
  for_each = NULL,
  color_gradient = c("blue", "beige", "red"),
  title = NULL,
  subtitle = NULL,
  x_lab = NULL,
  y_lab = NULL
)
}
\arguments{
\item{data}{Data frame containing all input variables.}

\item{response}{Numeric variable in \code{data} whose mean to compute.}

\item{x}{Variable in \code{data} for the horizontal axis.}

\item{y}{Variable in \code{data} for the vertical axis.}

\item{stratify_by}{(Optional) Stratification variable. If
supplied, means are computed for each combination of \code{x}, \code{y} and
\code{stratify_by}, and separate heatmaps are generated per level of \code{stratify_by}.}

\item{for_each}{(Optional) Additional stratification variable.
If supplied, separate plot windows are created per level of \code{for_each}.}

\item{color_gradient}{(Optional) Color gradient for the heatmap. Specified as a character vector of three colors, representing: c(<low_counts>, <middle_counts>, <high_counts>).
Defaults to \code{c("blue", "beige", "red")}. Colors must be recognized by \code{\link[ggplot2]{ggplot}}.}

\item{title}{Plot title; defaults to \code{NULL}, in which case a title
of the form "Mean \code{<response>}" is used.}

\item{subtitle}{(Optional) Plot subtitle; defaults to \code{NULL} if for \code{for_each} is \code{NULL},
defaults to \code{<name of for_each>: <level of for_each>} for each plot window if \code{for_each} is supplied.}

\item{x_lab}{(Optional) Label for the x-axis; defaults to the name of \code{x}.}

\item{y_lab}{(Optional) Label for the y-axis; defaults to the name of \code{y}.}
}
\value{
A \link[ggplot2]{ggplot} object showing the mean of \code{response}
across \code{x} and \code{y}, optionally faceted by \code{facet_row} and/or \code{facet_col}.
}
\description{
Computes the mean of a specified response variable for each combination of two
variables and displays it as a heatmap using \pkg{ggplot2}. If a stratification variable
is provided, means are calculated per strata and strata-specific heatmaps are displayed in individual panels.
If an additional stratification variable is provided, separate plot windows are created for each level.
}
\examples{
data("toy_data")
# Mean count by age and period
plot_mean_response_2D(toy_data, response = count, x = period, y = age)
# Mean count by age and period, stratified by education level
plot_mean_response_2D(toy_data, response = count, x = period, y = age,
                      stratify_by = education)
# Mean count by age and period, stratified by education level, for each sex
plot_mean_response_2D(toy_data, response = count, x = period, y = age,
                      stratify_by = education, for_each = sex)
}
\seealso{
\code{\link{plot_mean_response_1D}}, \code{\link[ggplot2]{ggplot}}
}
