% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-ObservationCounts.R
\name{plot_mean_response_1D}
\alias{plot_mean_response_1D}
\title{Plot mean of a response variable across a single variable, optionally stratified}
\usage{
plot_mean_response_1D(
  data,
  response,
  x,
  stratify_by = NULL,
  for_each = NULL,
  title = NULL,
  subtitle = NULL,
  legend_title = NULL,
  x_lab = NULL,
  y_lab = NULL,
  viridis_color_option = "D"
)
}
\arguments{
\item{data}{A \code{data.frame} or tibble containing the dataset.}

\item{response}{A numeric variable in \code{data} whose mean will be plotted.}

\item{x}{A variable in \code{data} defining the x-axis for computing means.}

\item{stratify_by}{(Optional) Stratification variable. If
supplied, counts are computed for each combination of \code{x} and
\code{stratify_by}, and separate lines are drawn per level of \code{stratify_by}.}

\item{for_each}{(Optional) Additional stratification variable. If supplied,
separate plot windows are created per level of \code{for_each}.}

\item{title}{(Optional) Plot title; defaults to \code{"Observation counts"}.}

\item{subtitle}{(Optional) Plot subtitle; defaults to \code{NULL} if for \code{for_each} is \code{NULL},
defaults to \code{<name of for_each>: <level of for_each>} for each plot window if \code{for_each} is supplied.}

\item{legend_title}{(Optional) Legend title; defaults to name of \code{stratify_var} if it is supplied.}

\item{x_lab}{(Optional) Label for the x-axis; defaults to the name of \code{x}.}

\item{y_lab}{(Optional) Label for the y-axis; defaults to the name of \code{paste("Mean", <response_name>)}.}

\item{viridis_color_option}{(Optional) Option for color gradient; defaults to "D".
Options are "A", "B", "C", "D", E", "F", "G", "H".
See \pkg{viridis} for information, or experiment yourself.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object displaying the mean of the response across the variable supplied in \code{x},
optionally stratified by \code{stratify_by}. If \code{for_each} is supplied, separate plots are created  in separate windows for each level.
Visuals can be modified with \pkg{ggplot2}.
}
\description{
Computes the mean of a specified response variable at each value of a specified x variable
and displays a line plot using \pkg{ggplot2}. If a stratification variable
is provided, means are calculated per strata and plotted as separate colored lines.
If an additional stratification variable is provided, separate plot windows are created for each level.
}
\examples{
data("toy_data")
# Mean by age
plot_mean_response_1D(toy_data, response = count, x = age)
# Mean count by age, stratified by education
plot_mean_response_1D(toy_data, response = count, x = age,
                      stratify_by = education)
# Mean count by age, stratified by education, for each sex
plot_mean_response_1D(toy_data, response = count, x = age,
                      stratify_by = education, for_each = sex)
}
\seealso{
\code{\link{plot_mean_response_2D}}, \code{\link[ggplot2]{ggplot}}
}
