% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_counts.R
\name{normalize_counts}
\alias{normalize_counts}
\title{Normalize counts between sensor outputs}
\usage{
normalize_counts(dataset, gain.columns, count.columns, gain.ratio.table)
}
\arguments{
\item{dataset}{a \code{data.table} containing gain and count columns.}

\item{gain.columns}{a \code{character} vector of columns in the \code{dataset}
containing a gain setting. Columns must not repeat.}

\item{count.columns}{a \code{character} vector of columns in the \code{dataset}
containing raw count data. Must be of the same length as \code{gain.columns},
and the order must conform to the order in \code{gain.columns}.}

\item{gain.ratio.table}{a two-column tibble containing \code{gain} and
\code{gain.ratio} information. Can be provided by the user or use the
\code{gain.ratio.table} dataset.}
}
\value{
an extended dataset with new columns containing normalized counts
}
\description{
This is a niche helper function to normalize counts. Some sensors provide raw
counts and gain levels as part of their output. In some cases it is desirable
to compare counts between sensors, e.g., to gauge daylight outside by
comparing UV counts to photopic counts (a high ratio of UV/Pho indicates
outside daylight). Or to gauge daylight inside by comparing IR counts to
photopic counts (a high ratio of IR/Pho with a low ratio of UV/Pho indicates
daylight in the context of LED or fluorescent lighting). The user can provide
their own gain ratiotable, or use a table provided for a sensor in the
\code{gain.ratio.table} dataset from \code{LightLogR}.
}
\examples{
example.table <-
tibble::tibble(
uvGain = c(4096, 1024, 2),
visGain = c(4096, 4096, 4096),
irGain = c(2,2,2),
uvValue = c(692, 709, 658),
visValue = c(128369, 129657, 128609),
irValue = c(122193, 127113, 124837))

gain.columns = c("uvGain", "visGain", "irGain")
count.columns = c("uvValue", "visValue", "irValue")

example.table |>
normalize_counts(gain.columns, count.columns, gain.ratio.tables$TSL2585)
}
\seealso{
Other Spectrum: 
\code{\link{spectral_integration}()},
\code{\link{spectral_reconstruction}()}
}
\concept{Spectrum}
