% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{log_zero_inflated}
\alias{log_zero_inflated}
\alias{exp_zero_inflated}
\title{Add a defined number to a numeric and log transform it}
\usage{
log_zero_inflated(x, offset = 0.1, base = 10)

exp_zero_inflated(x, offset = 0.1, base = 10)
}
\arguments{
\item{x}{A numeric vector}

\item{offset}{the amount to add to \code{x}, by default \code{0.1}}

\item{base}{The logarithmic base, by default \code{10}}
}
\value{
a transformed numeric vector
}
\description{
Frequently, light exposure data need to be log-transformed. Because light
exposure data frequently also contain many zero-values, adding a small value
avoids losing those observations. Must be applied with care and reported.

\code{\link[=exp_zero_inflated]{exp_zero_inflated()}} is the reverse function to \code{\link[=log_zero_inflated]{log_zero_inflated()}}.
}
\examples{
c(0, 1, 10, 100, 1000, 10000) |> log_zero_inflated()

#For use in a function
sample.data.environment |>
  dplyr::filter(Id == "Participant") |>
  dplyr::group_by(Date = lubridate::wday(Datetime, label = TRUE, week_start = 1)) |>
  dplyr::summarize(
  TAT250 = duration_above_threshold(log_zero_inflated(MEDI),
                                    Datetime,
                                    threshold = log_zero_inflated(250)
                                    )
                   )
                   

#Calling exp_zero_inflated on data transformed with log_zero_inflated yields to the original result
c(0, 1, 10, 100, 1000, 10000) |> log_zero_inflated() |> exp_zero_inflated()
}
\references{
Johannes Zauner, Carolina Guidolin, Manuel Spitschan (2025) How
to deal with darkness: Modelling and visualization of zero-inflated
personal light exposure data on a logarithmic scale. J Biol Rhythms. 2025
Oct;40(5):480-490. doi: https://doi.org/10.1177/07487304251336624
}
