% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_LL.R
\docType{data}
\name{import_Dataset}
\alias{import_Dataset}
\alias{import}
\title{Import a light logger dataset or related data}
\format{
An object of class \code{list} of length 19.
}
\usage{
import_Dataset(device, ...)

import
}
\arguments{
\item{device}{From what device do you want to import? For a few devices,
there is a sample data file that you can use to test the function (see the
examples). See \code{\link[=supported_devices]{supported_devices()}} for a list of supported devices and
see below for more information on devices with specific requirements.}

\item{...}{Parameters that get handed down to the specific import functions}
}
\value{
Tibble/Dataframe with a POSIXct column for the datetime
}
\description{
Imports a dataset and does the necessary transformations to get the right
column formats. Unless specified otherwise, the function will set the
timezone of the data to \code{UTC}. It will also enforce an \code{Id} to separate
different datasets and will order/arrange the dataset within each \code{Id} by
Datetime. See the Details and Devices section for more information and the
full list of arguments.
}
\details{
There are specific and a general import function. The general import
function is described below, whereas the specific import functions take the
form of \code{import$device()}. The general import function is a thin wrapper
around the specific import functions. The specific import functions take
the following arguments:
\itemize{
\item \code{filename}: Filename(s) for the Dataset. Can also contain the filepath,
but \code{path} must then be \code{NULL}. Expects a \code{character}. If the vector is
longer than \code{1}, multiple files will be read in into one Tibble.
\item \code{path}: Optional path for the dataset(s). \code{NULL} is the default. Expects
a \code{character}.
\item \code{n_max}: maximum number of lines to read. Default is \code{Inf}.
\item \code{tz}: Timezone of the data. \code{"UTC"} is the default. Expects a
\code{character}. You can look up the supported timezones with \code{\link[=OlsonNames]{OlsonNames()}}.
\item \code{version}: Data formats can change, e.g. with software updates. This
argument allows switching between known data formats of the same device
model. Expects a \code{character} scalar. The default is \code{"default"}, which will
always use the latest version. To find out which software versions are
contained, call \code{\link[=supported_versions]{supported_versions()}}.
\item \code{Id.colname}: Lets you specify a column for the id of a dataset. Expects a
symbol (Default is \code{Id}). This column will be used for grouping
(\code{\link[dplyr:group_by]{dplyr::group_by()}}).
\item \code{auto.id}: If the \code{Id.colname} column is not part of the \code{dataset}, the \code{Id}
can be automatically extracted from the filename. The argument expects a
regular expression \link{regex} and will by default just give the whole filename
without file extension.
\item \code{manual.id}: If this argument is not \code{NULL}, and no \code{Id} column is part
of the \code{dataset}, this \code{character} scalar will be used. \strong{We discourage the
use of this arguments when importing more than one file}
\item \code{silent}: If set to \code{TRUE}, the function will not print a summary message
of the import or plot the overview. Default is \code{FALSE}.
\item \code{locale}: The locale controls defaults that vary from place to place.
\item \code{not.before}: Remove data prior to this date. This argument is provided to \code{start} of \code{\link[=filter_Date]{filter_Date()}}. Data will be filtered out before any of the summaries are shown.
\item \code{dst_adjustment}: If a file crosses daylight savings time, but the device does not adjust time stamps accordingly, you can set this argument to \code{TRUE}, to apply this shift manually. It is selective, so it will only be done in files that cross between DST and standard time. Default is \code{FALSE}. Uses \code{\link[=dst_change_handler]{dst_change_handler()}} to do the adjustment. Look there for more infos. It is not equipped to handle two jumps in one file (so back and forth between DST and standard time), but will work fine if jums occur in separate files.
\item \code{auto.plot}: a logical on whether to call \code{\link[=gg_overview]{gg_overview()}} after import. Default is \code{TRUE}. But is set to \code{FALSE} if the argument \code{silent} is set to \code{TRUE}.
\item \code{...}: supply additional arguments to the \pkg{readr} import functions, like \code{na}. Might also be used to supply arguments to the specific import functions, like \code{column_names} for \code{Actiwatch_Spectrum} devices. Those devices will always throw a helpful error message if you forget to supply the necessary arguments.
If the \code{Id} column is already part of the \code{dataset} it will just use this
column. If the column is not present it will add this column and fill it
with the filename of the importfile (see param \code{auto.id}).
\item \code{print_n} can be used if you want to see more rows from the observation intervals
\item \code{remove_duplicates} can be used if identical observations are present
within or across multiple files. The default is \code{FALSE}. The function keeps
only unique observations (=rows) if set to' TRUE'. This is a convenience
implementation of \code{\link[dplyr:distinct]{dplyr::distinct()}}.
}
}
\section{Devices}{
 The set of import functions provide a convenient way to
import light logger data that is then perfectly formatted to add metadata,
make visualizations and analyses. There are a number of devices supported,
where import should just work out of the box. To get an overview, you can
simply call the \code{supported_devices()} dataset. The list will grow
continuously as the package is maintained. More than one data formats may
be available for a given device. Check with \code{supported_versions()} if you
run into problems with imports, despite a correct device setting.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{supported_devices()
#>  [1] "ActLumus"           "ActTrust"           "Actiwatch_Spectrum"
#>  [4] "Circadian_Eye"      "Clouclip"           "DeLux"             
#>  [7] "GENEActiv_GGIR"     "Kronowise"          "LIMO"              
#> [10] "LYS"                "LiDo"               "LightWatcher"      
#> [13] "MiEye"              "MotionWatch8"       "OcuWEAR"           
#> [16] "Speccy"             "SpectraWear"        "VEET"              
#> [19] "nanoLambda"
}\if{html}{\out{</div>}}
\subsection{ActLumus}{

Manufacturer: Condor Instruments

Model: ActLumus

Implemented: Sep 2023

A sample file is provided with the package, it can be accessed through
\code{system.file("extdata/205_actlumus_Log_1020_20230904101707532.txt.zip", package = "LightLogR")}. It does not need to be unzipped to be imported.
This sample file is a good example for a regular dataset without gaps.
}

\subsection{LYS}{

Manufacturer: LYS Technologies

Model: LYS Button

Implemented: Sep 2023

A sample file is provided with the package, it can be accessed through
\code{sample.data.irregular}. This
sample file is a good example for an irregular dataset.
}

\subsection{Actiwatch_Spectrum & Actiwatch_Spectrum_de}{

Manufacturer: Philips Respironics

Model: Actiwatch Spectrum

Implemented: Nov 2023 / July 2024
}

\subsection{ActTrust}{

Manufacturer: Condor Instruments

Model: ActTrust1, ActTrust2

Implemented: Mar 2024

This function works for both ActTrust 1 and 2 devices
}

\subsection{Speccy}{

Manufacturer: Monash University

Model: Speccy

Implemented: Feb 2024
}

\subsection{DeLux}{

Manufacturer: Intelligent Automation Inc

Model: DeLux

Implemented: Dec 2023
}

\subsection{LiDo}{

Manufacturer: University of Lucerne

Model: LiDo

Implemented: Nov 2023
}

\subsection{SpectraWear}{

Manufacturer: University of Manchester

Model: SpectraWear

Implemented: May 2024
}

\subsection{NanoLambda}{

Manufacturer: NanoLambda

Model: XL-500 BLE

Implemented: May 2024
}

\subsection{LightWatcher}{

Manufacturer: Object-Tracker

Model: LightWatcher

Implemented: June 2024
}

\subsection{VEET}{

Manufacturer: Meta Reality Labs

Model: VEET

Implemented: July 2024

\strong{Required Argument: \code{modality}} A character scalar describing the
modality to be imported from. Can be one of \code{"ALS"} (Ambient light sensor),
\code{"IMU"} (Inertial Measurement Unit), \code{"INF"} (Information), \code{"PHO"}
(Spectral Sensor), \code{"TOF"} (Time of Flight)
}

\subsection{Circadian_Eye}{

Manufacturer: Max-Planck-Institute for Biological Cybernetics, Tübingen

Model: melanopiQ Circadian Eye (Prototype)

Implemented: July 2024
}

\subsection{Kronowise}{

Manufacturer: Kronohealth

Model: Kronowise

Implemented: July 2024
}

\subsection{GENEActiv with GGIR preprocessing}{

Manufacturer: Activeinsights

Model: GENEActiv

\strong{Note:} This import function takes GENEActiv data that was preprocessed
through the \href{https://cran.r-project.org/package=GGIR}{GGIR} package. By
default, \code{GGIR} aggregates light data into intervals of 15 minutes. This
can be set by the \code{windowsizes} argument in GGIR, which is a three-value
vector, where the second values is set to 900 seconds by default. To import
the preprocessed data with \code{LightLogR}, the \code{filename} argument requires a
path to the parent directory of the GGIR output folders, specifically the
\code{meta} folder, which contains the light exposure data. Multiple \code{filename}s
can be specified, each of which needs to be a path to a different GGIR
parent directory. GGIR exports can contain data from multiple participants,
these will always be imported fully by providing the parent directory. Use
the \code{pattern} argument to extract sensible \code{Id}s from the \emph{.RData}
filenames within the \emph{meta/basic/} folder. As per the author, \href{https://www.accelting.com}{Dr. Vincent van Hees}, GGIR preprocessed data are always in
local time, provided the \code{desiredtz}/\code{configtz} are properly set in GGIR.
\code{LightLogR} still requires a timezone to be set, but will not timeshift the
import data.
}

\subsection{MotionWatch 8}{

Manufacturer: CamNtech

Implemented: September 2024
}

\subsection{LIMO}{

Manufacturer: ENTPE

Implemented: September 2024

LIMO exports \code{LIGHT} data and \code{IMU} (inertia measurements, also UV) in
separate files. Both can be read in with this function, but not at the same
time. Please decide what type of data you need and provide the respective
filenames.
}

\subsection{OcuWEAR}{

Manufacturer: Ocutune

Implemented: September 2024

OcuWEAR data contains spectral data. Due to the format of the data file,
the spectrum is not directly part of the tibble, but rather a list column
of tibbles within the imported data, containing a \code{Wavelength} (nm) and
\code{Intensity} (mW/m^2) column.
}

\subsection{Clouclip}{

Manufacturer: Clouclip

Implemented: April 2025

Clouclip export files have the ending \code{.xls}, but are no real Microsoft
Excel files, rather they are tab-separated text files. LightLogR thus does
not read them in with an excel import routine. The measurement columns
\code{Lux} and \code{Dis} contain sentinel values. \code{-1} (\code{Dis} and \code{Lux}) indicates
sleep mode, whereas \code{204} (only \code{Dis}) indicates an out of range
measurement. These values will be set to \code{NA}, and an additional column is
added that translates these status codes. The columns carry the name
\verb{\{.col\}_status}.
}

\subsection{MiEye}{

Manufacturer: CHI. Circadian Health Innovations

Implemented: October 2025
}
}

\section{Examples}{

\subsection{Imports made easy}{

To import a file, simple specify the filename (and path) and feed it to the
\code{import_Dataset} function. There are sample datasets for all devices.

The import functions provide a basic overview of the data after import,
such as the intervals between measurements or the start and end dates.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{filepath <- system.file("extdata/205_actlumus_Log_1020_20230904101707532.txt.zip", package = "LightLogR")
dataset <- import_Dataset("ActLumus", filepath, auto.plot = FALSE)
#> Multiple files in zip: reading '205_actlumus_Log_1020_20230904101707532.txt'
#> 
#> Successfully read in 61'016 observations across 1 Ids from 1 ActLumus-file(s).
#> Timezone set is UTC.
#> The system timezone is Europe/Berlin. Please correct if necessary!
#> 
#> First Observation: 2023-08-28 08:47:54
#> Last Observation: 2023-09-04 10:17:04
#> Timespan: 7.1 days
#> 
#> Observation intervals: 
#>   Id                                          interval.time     n pct  
#> 1 205_actlumus_Log_1020_20230904101707532.txt 10s           61015 100\%
}\if{html}{\out{</div>}}

Import functions can also be called directly:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dataset <- import$ActLumus(filepath, auto.plot = FALSE)
#> Multiple files in zip: reading '205_actlumus_Log_1020_20230904101707532.txt'
#> 
#> Successfully read in 61'016 observations across 1 Ids from 1 ActLumus-file(s).
#> Timezone set is UTC.
#> The system timezone is Europe/Berlin. Please correct if necessary!
#> 
#> First Observation: 2023-08-28 08:47:54
#> Last Observation: 2023-09-04 10:17:04
#> Timespan: 7.1 days
#> 
#> Observation intervals: 
#>   Id                                          interval.time     n pct  
#> 1 205_actlumus_Log_1020_20230904101707532.txt 10s           61015 100\%
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dataset \%>\%
dplyr::select(Datetime, TEMPERATURE, LIGHT, MEDI, Id) \%>\%
dplyr::slice(1500:1505)
#> # A tibble: 6 x 5
#> # Groups:   Id [1]
#>   Datetime            TEMPERATURE LIGHT  MEDI Id                                
#>   <dttm>                    <dbl> <dbl> <dbl> <fct>                             
#> 1 2023-08-28 12:57:44        26.9  212.  202. 205_actlumus_Log_1020_20230904101~
#> 2 2023-08-28 12:57:54        26.9  208.  199. 205_actlumus_Log_1020_20230904101~
#> 3 2023-08-28 12:58:04        26.9  205.  196. 205_actlumus_Log_1020_20230904101~
#> 4 2023-08-28 12:58:14        26.8  204.  194. 205_actlumus_Log_1020_20230904101~
#> 5 2023-08-28 12:58:24        26.9  203.  194. 205_actlumus_Log_1020_20230904101~
#> 6 2023-08-28 12:58:34        26.8  204.  195. 205_actlumus_Log_1020_20230904101~
}\if{html}{\out{</div>}}
}
}

\seealso{
\link{supported_devices}
}
\keyword{datasets}
