% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_day.r
\name{gg_day}
\alias{gg_day}
\title{Create a simple Time-of-Day plot of light logger data, faceted by Date}
\usage{
gg_day(
  dataset,
  y.axis = MEDI,
  geom = "point",
  start.date = NULL,
  end.date = NULL,
  x.axis = Datetime,
  aes_col = NULL,
  aes_fill = NULL,
  group = Id,
  scales = c("fixed", "free_x", "free_y", "free"),
  x.axis.breaks = hms::hms(hours = seq(0, 24, by = 3)),
  y.axis.breaks = c(-10^(5:0), 0, 10^(0:5)),
  y.scale = "symlog",
  y.scale.sc = FALSE,
  x.axis.label = "Local time (HH:MM)",
  y.axis.label = "Melanopic EDI (lx)",
  format.day = "\%d/\%m",
  title = NULL,
  subtitle = NULL,
  interactive = FALSE,
  facetting = TRUE,
  jco_color = TRUE,
  ...
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a \code{dataframe}. If not imported
by \link{LightLogR}, take care to choose a sensible variable for the \code{x.axis.}.}

\item{geom}{What geom should be used for visualization? Expects a \code{character}
\itemize{
\item \code{"point"} for \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}
\item \code{"line"}  for \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}
\item \code{"ribbon"} for \code{\link[ggplot2:geom_ribbon]{ggplot2::geom_ribbon()}}
\item as the value is just input into the \code{geom_} function from \pkg{ggplot2}, other variants work as well, but are not extensively tested.
}}

\item{start.date, end.date}{Choose an optional start or end date within your
\code{dataset}. Expects a \code{date}, which can also be a \code{character} that is
interpretable as a date, e.g., \code{"2023-06-03"}. If you need a Datetime or
want to cut specific times of each day, use the \code{\link[=filter_Datetime]{filter_Datetime()}}
function. Defaults to \code{NULL}, which means that the plot starts/ends with
the earliest/latest date within the \code{dataset}.}

\item{x.axis, y.axis}{column name that contains the datetime (x, defaults to
\code{"Datetime"} which is automatically correct for data imported with
\link{LightLogR}) and the dependent variable (y, defaults to \code{"MEDI"}, or
melanopic EDI, which is a standard measure of stimulus strength for the
nonvisual effects of light). Expects a \code{symbol}. Needs to be part of the
\code{dataset}.}

\item{aes_col, aes_fill}{optional arguments that define separate sets and
colors or fills them. Expects anything that works with the layer data
\code{\link[ggplot2:aes]{ggplot2::aes()}}. The default color palette can be overwritten outside the
function (see examples).}

\item{group}{Optional column name that defines separate sets. Useful for
certain geoms like \code{boxplot}.Expects anything that works with the layer
data \code{\link[ggplot2:aes]{ggplot2::aes()}}}

\item{scales}{For \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}, should scales be "fixed", "free"
or free in one dimension ("free_y" is the default). Expects a \code{character}.}

\item{x.axis.breaks, y.axis.breaks}{Where should breaks occur on the x and
y.axis? Expects a \verb{numeric vector} with all the breaks. If you want to
activate the default behaviour of \pkg{ggplot2}, you need to put in
\code{\link[ggplot2:waiver]{ggplot2::waiver()}}.}

\item{y.scale}{How should the y-axis be scaled?
\itemize{
\item Defaults to \code{"symlog"}, which is a logarithmic scale that can also handle negative values.
\item \code{"log10"} would be a straight logarithmic scale, but cannot handle negative values.
\item \code{"identity"} does nothing (continuous scaling).
\item a transforming function, such as \code{\link[=symlog_trans]{symlog_trans()}} or \code{\link[scales:transform_identity]{scales::identity_trans()}}, which allow for more control.
}}

\item{y.scale.sc}{\code{logical} for whether scientific notation shall be used.
Defaults to \code{FALSE}.}

\item{x.axis.label, y.axis.label}{labels for the x- and y-axis. Expects a
\code{character}.}

\item{format.day}{Label for each day. Default is \verb{\%d/\%m}, which shows the day
and month. Expects a \code{character}. For an overview of sensible options look
at \code{\link[base:strptime]{base::strptime()}}}

\item{title}{Plot title. Expects a \code{character}.}

\item{subtitle}{Plot subtitle. Expects a \code{character}.}

\item{interactive}{Should the plot be interactive? Expects a \code{logical}.
Defaults to \code{FALSE}.}

\item{facetting}{Should an automated facet by day be applied? Default is
\code{TRUE} and uses the \code{Day.data} variable that the function also creates if
not present.}

\item{jco_color}{Should the \code{\link[ggsci:scale_jco]{ggsci::scale_color_jco()}} color palette be used?
Defaults to \code{TRUE}.}

\item{...}{Other options that get passed to the main geom function. Can be
used to adjust to adjust size, linewidth, or linetype.}
}
\value{
A ggplot object
}
\description{
\code{\link[=gg_day]{gg_day()}} will create a simple ggplot for every data in a dataset. The
result can further be manipulated like any ggplot. This will be sensible to
refine styling or guides.
}
\details{
Besides plotting, the function creates two new variables from the given
\code{Datetime}:
\itemize{
\item \code{Day.data} is a factor that is used for facetting with \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}. Make sure to use this variable, if you change the faceting manually. Also, the function checks, whether this variable already exists. If it does, it will only convert it to a factor and do the faceting on that variable.
\item \code{Time} is an \code{hms} created with \code{\link[hms:hms]{hms::as_hms()}} that is used for the x.axis
}

The default scaling of the y-axis is a \code{symlog} scale, which is a logarithmic
scale that only starts scaling after a given threshold (default = 0). This
enables values of 0 in the plot, which are common in light logger data, and
even enables negative values, which might be sensible for non-light data. See
\code{\link[=symlog_trans]{symlog_trans()}} for details on tweaking this scale. The scale can also be
changed to a normal or logarithmic scale - see the y.scale argument for more.

The default scaling of the color and fill scales is discrete, with the
\code{\link[ggsci:scale_jco]{ggsci::scale_color_jco()}} and \code{\link[ggsci:scale_jco]{ggsci::scale_fill_jco()}} scales. To use a
continuous scale, use the \code{jco_color = FALSE} setting. Both \code{fill} and
\code{color} aesthetics are set to \code{NULL} by default. For most geoms, this is not
important, but geoms that automatically use those aesthetics (like
geom_bin2d, where fill = stat(count)) are affected by this. Manually adding
the required aesthetic (like \code{aes_fill = ggplot2::stat(count)} will fix
this).
}
\examples{
#use `col`for separation of different sets
plot <- gg_day(
sample.data.environment,
scales = "fixed",
end.date = "2023-08-31",
y.axis.label = "mEDI (lx)",
aes_col = Id)
plot

#you can easily overwrite the color scale afterwards
plot + ggplot2::scale_color_discrete()

#or change the facetting
plot + ggplot2::facet_wrap(~Day.data + Id)
}
