% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Datetime2Time.R
\name{Datetime2Time}
\alias{Datetime2Time}
\title{Convert Datetime columns to Time columns}
\usage{
Datetime2Time(
  dataset,
  cols = dplyr::where(lubridate::is.POSIXct),
  circular = FALSE,
  silent = FALSE
)
}
\arguments{
\item{dataset}{A data.frame with POSIXct columns.}

\item{cols}{The column names to convert. Expects a \code{symbol}. The default will
convert all POSIXct columns. If uncertain whether columns exist in the
dataset, use \code{\link[dplyr:reexports]{dplyr::any_of()}}.}

\item{circular}{Logical on whether the columns should be converted to a
circular time instead of time stamps. Uses the \code{\link[circular:circular]{circular::circular()}}
class with a \code{clock24} template for a clean round-trip with
\code{\link[=Circular2Time]{Circular2Time()}}. Default is \code{FALSE}.}

\item{silent}{Logical on whether no message shall be shown if input and
output are identical. Defaults to \code{FALSE} (i.e., a message is shown).}
}
\value{
The input dataset with converted POSIXct columns as time (hms)
columns. With the default settings, if no POSIXct column exists, input and
output will be identical.
}
\description{
Convert Datetime columns to Time columns
}
\examples{
sample.data.environment |> Datetime2Time()
#more than one POSIX col
sample.data.environment |>
  dplyr::mutate(Datetime2 = lubridate::POSIXct(1)) |>
  Datetime2Time()
#only converting one of them
sample.data.environment |>
  dplyr::mutate(Datetime2 = lubridate::POSIXct(1)) |>
  Datetime2Time(Datetime)
#if uncertain whether column exists
sample.data.environment |>
  Datetime2Time(dplyr::any_of("Datetime3"))
}
