% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plotPIP}
\alias{plotPIP}
\title{Visualization of Posterior Inclusion Probabilities}
\usage{
plotPIP(x,
        variable_names = NULL,
        sort           = TRUE)
}
\arguments{
\item{x}{The output object of \code{ULLGM_BMA}.}

\item{variable_names}{A character vector specifying the names of the columns of X.}

\item{sort}{Logical, indicating whether the plot should be sorted by PIP. Defaults to \code{TRUE}.}
}
\value{
Returns a 'ggplot2::ggplot' object.
}
\description{
\code{plotPIP} produces a visualization of the posterior inclusion probabilities (PIPs) extracted from \code{ULLGM_BMA} results.
}
\examples{
# Load package
library(LatentBMA)

# Example: Estimate a PLN model under a BRIC prior with m = p/2 using simulated data
# Note: Use more samples for actual analysis
# Note: nsave = 250 and nburn = 250 are for demonstration purposes
X <- matrix(rnorm(100*20), 100, 20)
z <- 2 + X \%*\% c(0.5, -0.5, rep(0, 18)) + rnorm(100, 0, sqrt(0.25))
y <- rpois(100, exp(z))
results_pln <- ULLGM_BMA(X = X, y = y, model = "PLN", nsave = 250, nburn = 250)
plotPIP(results_pln)

}
\author{
Gregor Zens
}
