% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{\%sp\%}
\alias{\%sp\%}
\title{Sparsity-retaining matrix multiplication}
\usage{
A \%sp\% B
}
\arguments{
\item{A}{matrix of dimension n x p}

\item{B}{matrix of dimension p x m}
}
\value{
the matrix product of A and B, which is of dimension n x m
}
\description{
Standard matrix multiplication destroys automatic sparsity detection by \code{RTMB} which is essential for models with high-dimensional random effects.
This can be mitigated by changing to "plain" with \code{TapeConfig}, but this can make AD tape construction very slow.
Here, we provide a different version that retains sparsity. It may be slightly slower than the standard method when constructing the AD tape.
}
\examples{
A <- matrix(1:6, nrow = 2, ncol = 3)
B <- matrix(7:12, nrow = 3, ncol = 2)
A \%sp\% B
}
