% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Births2022.R
\docType{data}
\name{Births2022}
\alias{Births2022}
\title{Records on births in the US in 2022}
\format{
A data frame with 20,000 observations on the following 38 variables. The unit of observation
is a birth.
\itemize{
\item \code{month}: 1-12
\item \code{dow}: Day of week: Sun, Mon, Tues, ...
\item \code{place}: hospital, home, clinic, etc.
\item \code{paternity}: is paternity acknowledged. Y, N, and X. X stands for "not applicable"
which is shorthand for the mother is married (consequently the husband is presumed
to be the father).
\item \code{meduc}: mother's educational level. <8 is 8th grade or less, HSG+ means
high school plus some college but no degree.
\item \code{feduc}: father's education. Same coding as \code{meduc}.
\item \code{married}: Is the mother married?
\item \code{mage}: mother's age
\item \code{fage}: father's age
\item \code{total_kids}: how many total births to mother including this one.
\item \code{interval}: months since last birth (if applicable).
\item \code{prenatal_start}: Which trimester did the mother start prenatal care?
\item \code{prenatal_visits}: How many total prenatal care visits.
\item \code{mheight}: Mother's height in inches
\item \code{wt_pre}: Mother's weight in pounds before pregnancy
\item \code{wt_delivery}: Mother's weight in pounds at delivery
\item \code{diabetes_pre}: Did the mother have diabetes before pregnancy
\item \code{diabetes_gest}: Did the mother develop gestational diabetes
\item \code{hbp_pre}: Did the mother have high blood pressure before pregancy
\item \code{hbp_gest}: Did the mother develop high blood pressure during pregnancy
\item \code{eclampsia}: Did the mother develop eclampsia
\item \code{induction}: Was labor induced?
\item \code{augmentation}: Was the uterus stimulated to increase frequency, duration, and
intensity of contractions.
\item \code{anesthesia}: Was the mother given anesthesia?
\item \code{presentation}: Baby's presentation at birth (e.g. cephalic or breech)
\item \code{method}: method of delivery (vaginal or C-section)
\item \code{trial_at_labor}: For mother's who delivered by C-section, was there an
attempt at labor.
\item \code{attendant}: MD, DO, midwife, other
\item \code{payment}: How was the bill paid?
\item \code{apgar5}, \code{apgar10}: APGAR scores (0-10) at five and ten minutes after birth.
\item \code{plurality}: singletons, twins, triplets, quadruplets (as an integer 1-4)
\item \code{sex}: Baby's sex
\item \code{duration}: Duration of gestation, in weeks by "obstretric estimate."
\item \code{menses}: Last normal menses month: 1-12 (Jan-Dec)
\item \code{weight}: Baby's weight (in grams)
\item \code{living}: Baby living at time of birth report
\item \code{breastfed}: Baby breastfed at time of discharge
}
}
\source{
US Centers for Disease Control "Natality Public Use File", CDC vital stats online
}
\usage{
Births2022
}
\description{
These data come from the Centers for Disease Controls "public use file" recording
all 3,699,040 (known) births in the US in 2022. \code{Births2022} is a random
sample of size 20,000 from the comprehensive file
}
\references{
"User Guide to the 2022 Natality Public Use File"
}
\keyword{datasets}
