% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{E_Valor}
\alias{E_Valor}
\title{Land Surface Emissivity according to Valor and Caselles 1996}
\usage{
E_Valor(NDVI)
}
\arguments{
\item{NDVI}{SpatRaster object, NDVI calculated from remote sensing imagery}
}
\value{
SpatRaster
}
\description{
This function calculates Land Surface Emissivity according to Valor and Caselles 1996
}
\examples{
NDVI <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(NDVI) = runif(10000, min=0.02, max=0.8)
E_Valor(NDVI)
}
\references{
Valor, E. and Caselles, V., 1996. Mapping land surface emissivity from NDVI: Application to European, African, and South American areas. Remote sensing of Environment, 57(3), pp.167-184.
}
