#' the Scaler for the Pre-Trained Long Short Term Memory (LSTM) Network
#'
#' @description
#' This dataset contains the means and standard deviations of the 1,000,000 datasets for
#' training the Long Short Term Memory (LSTM) Network, which can be used to determine the number of factors.
#'
#' @format A \code{list} containing two \code{vector}s, each of length 20:
#' \describe{
#'   \item{means}{A numeric vector representing the means of the 20
#'                features extracted from the 1,000,000 datasets.}
#'   \item{sds}{A numeric vector representing the standard deviations of
#'              the 20 features extracted from the 1,000,000 datasets.}
#' }
#' @seealso \link[LSTMfactors]{LSTM}, \link[LSTMfactors]{load.scaler}, \link[LSTMfactors]{data.datasets.LSTM}, \link[LSTMfactors]{normalizor}
#'
#'
#' @examples
#' data(data.scaler.LSTM)
#' print(data.scaler.LSTM)
#'
#' data.scaler <- load.scaler()
#' print(data.scaler)
#'
#' @docType data
#' @name data.scaler.LSTM
NULL
