% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{save_results}
\alias{save_results}
\title{Save search results to a file}
\usage{
save_results(results, file_path, format = c("csv", "rds", "xlsx"))
}
\arguments{
\item{results}{A data frame containing search results.}

\item{file_path}{File path to save the results. Must be specified by user.}

\item{format}{File format to use. One of "csv", "rds", or "xlsx".}
}
\value{
The file path (invisibly).
}
\description{
This function saves search results to a file.
}
\examples{
\donttest{
# Create sample results
results <- data.frame(
  pmid = c("12345", "67890"),
  title = c("Sample Title 1", "Sample Title 2"),
  abstract = c("Sample abstract 1", "Sample abstract 2")
)

# Save to temporary directory
temp_file <- file.path(tempdir(), "results.csv")
save_results(results, temp_file, format = "csv")

# Clean up
unlink(temp_file)
}
}
