% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_no.R
\name{mean_no}
\alias{mean_no}
\title{Non-parametric estimation of mean number of events}
\usage{
mean_no(
  formula,
  re_indicator,
  ce_indicator,
  cluster,
  data,
  re_control = list(),
  ce_control = list()
)
}
\arguments{
\item{formula}{A formula passed to \code{survfit}.}

\item{re_indicator}{The name of a variable indicating that these rows in the dataset belong
to the risksets of the recurrent event process.}

\item{ce_indicator}{The name of a variable indicating that these rows in the datasets belong
to the riskset of the competing event process.}

\item{cluster}{A character vector specifying the name of the variable that defines unique
observations in the dataset passed to the function. This is only used
for data checks}

\item{data}{A \code{data.frame} in stacked format. The dataset needs to include one row
for the competing event and one row for each risk episode of the
recurrent event.}

\item{re_control}{An optional \code{list} with arguments passed to \code{survfit} when computing
risksets for the recurrent event.}

\item{ce_control}{An optional \code{list} with arguments passed to \code{survfit} when computing
risksets for the competing event.}
}
\value{
A \code{data.frame} including the estimated mean number of events \code{expn}
at times \code{t} within strata \code{strata}.
}
\description{
Estimates the mean number of events using the non-parametric estimator
described by Cook and Lawless (1997).
}
\examples{
library(survival)
mean_no(Surv(time  = start,
             time2 = stop,
             event = event,
             type  = 'counting') ~ pyridoxine + thiotepa,
        re_indicator = "re",
        ce_indicator = "ce",
        cluster = "id",
        data = bladder1_stacked)

}
