% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_jaya_multi_pairwise}
\alias{plot_jaya_multi_pairwise}
\title{Pairwise Plot Function for Multi-Objective Optimization Results}
\usage{
plot_jaya_multi_pairwise(x, objectives = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{jaya_multi} containing the optimization results, including the Pareto front.}

\item{objectives}{A vector of objective column names to include in the pairwise plots.
If \code{NULL}, all objectives in the Pareto front are used.}

\item{...}{Additional graphical parameters passed to the \code{plot} function.}
}
\description{
Generates pairwise 2D plots for all combinations of objectives in the Pareto front.
This function visualizes trade-offs between different objectives.
}
\details{
The function automatically detects objectives in the Pareto front if not specified.
It creates pairwise plots for all possible combinations of objectives.
}
\examples{
# Example usage of plot_jaya_multi_pairwise
# Define sample multi-objective optimization problem
objective1 <- function(x) sum(x^2)
objective2 <- function(x) sum(abs(x))
objective3 <- function(x) sum(x^3)
objective4 <- function(x) sum(x^4)

objectives <- list(objective1, objective2, objective3, objective4)
lower_bounds <- c(-5, -5, -5)
upper_bounds <- c(5, 5, 5)

# Run multi-objective optimization using jaya_multi
set.seed(42)
multi_result <- jaya_multi(
  objectives = objectives,
  lower = lower_bounds,
  upper = upper_bounds,
  popSize = 50,
  maxiter = 100,
  n_var = length(lower_bounds)
)

# Pairwise plot of objectives
plot_jaya_multi_pairwise(multi_result)
}
