% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pspfit.R
\name{plot.pspfit}
\alias{plot.pspfit}
\title{Plotting function for \code{psNormal}, \code{psPoisson}, \code{psBinomial}}
\usage{
\method{plot}{pspfit}(x, ..., se = 2, xlab = "", ylab = "", col = "black", pch = 1)
}
\arguments{
\item{x}{the P-spline object, usually from psNormal, psPoisson, psBinomial.}

\item{...}{other parameters.}

\item{se}{a scalar, e.g. \code{se = 2} to produce twice se bands, set \code{se} > 0 (or set \code{se}=0 to supress).}

\item{xlab}{label for the x-axis.}

\item{ylab}{label for the y-axis.}

\item{col}{color for points.}

\item{pch}{point character.}
}
\value{
\item{Plot}{a plot of the mean (inverse link) smoothed normal, Poisson, or binomial responses, with or without se bands.}
}
\description{
Plotting function for P-spline smooth with normal, Poisson, or binomial responses
(\code{class pspfit}), with or without standard error bands.
}
\examples{
library(JOPS)
#Extract data
library(MASS)
# Get the data
data(mcycle)
x = mcycle$times
y = mcycle$accel
fit1 = psNormal(x, y, nseg = 20, bdeg = 3, pord = 2, lambda = .8)
plot(fit1, se = 2, xlab = "time (ms)", ylab = "accel")

library(JOPS)
library(boot)
# Extract the data
Count = hist(boot::coal$date, breaks=c(1851:1963), plot = FALSE)$counts
Year = c(1851:1962)
xl = min(Year)
xr = max(Year)

# Poisson smoothing
nseg = 20
bdeg = 3
fit1=psPoisson(Year, Count, xl, xr, nseg, bdeg, pord = 2,
lambda = 1)
names(fit1)
plot(fit1, xlab = "Year", ylab = "Count", se = 2)

library(JOPS)
#Extract data
library(rpart)
Kyphosis = kyphosis$Kyphosis
Age  =kyphosis$Age
y = 1 * (Kyphosis == "present")  # make y 0/1
# Binomial smoothing
fit1 = psBinomial(Age, y, xl = min(Age), xr = max(Age), nseg = 20,
                 bdeg = 3, pord = 2, lambda = 1)
names(fit1)
plot(fit1, xlab = "Age", ylab = '0/1', se = 2)

}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\author{
Paul Eilers and Brian Marx
}
