% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\name{rbind.QR_matrix}
\alias{rbind.QR_matrix}
\title{Combining QR_matrix objects}
\usage{
\method{rbind}{QR_matrix}(..., check_formula = TRUE)
}
\arguments{
\item{...}{\code{\link{QR_matrix}} objects to combine.}

\item{check_formula}{logical indicating whether to check the score formulas'
coherency.
By default, \code{check_formula = TRUE}: an error is returned if the scores
were calculated with different formulas. If \code{check_formula = FALSE}, no
check is performed and the \code{score_formula} of the output is \code{NULL}.}
}
\value{
\code{rbind.QR_matrix()} returns a \code{\link{QR_matrix}} object.
}
\description{
Function to combine multiple \code{\link{QR_matrix}} objects: line by line,
both for the \code{modalities} and the \code{values} table.
}
\examples{
# Path of matrix demetra_m
demetra_path <- file.path(
    system.file("extdata", package = "JDCruncheR"),
    "WS/ws_ipi/Output/SAProcessing-1",
    "demetra_m.csv"
)

# Extract the quality report from the demetra_m file
QR <- extract_QR(demetra_path)

# Compute differents scores
QR1 <- compute_score(QR, score_pond = c(m7 = 2, q = 3, qs_residual_sa_on_sa = 5))
QR2 <- compute_score(QR, score_pond = c(m7 = 2, qs_residual_sa_on_sa = 5))

# Merge two quality report
try(rbind(QR1, QR2)) # Une erreur est renvoyée
rbind(QR1, QR2, check_formula = FALSE)

}
\seealso{
\link[=fr-rbind.QR_matrix]{Traduction française}

Other QR_matrix functions: 
\code{\link{export_xlsx}()},
\code{\link{export_xlsx.QR_matrix}()},
\code{\link{export_xlsx.mQR_matrix}()},
\code{\link{extract_QR}()},
\code{\link{sort}()},
\code{\link{weighted_score}()}
}
\concept{QR_matrix functions}
