% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_indonesia_population.R
\name{get_indonesia_population}
\alias{get_indonesia_population}
\title{Get Indonesia's Total Population from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SP.POP.TOTL}
}
\usage{
get_indonesia_population()
}
\value{
A tibble with:
\itemize{
  \item \code{indicator}: Indicator name.
  \item \code{country}: Country name ("Indonesia").
  \item \code{year}: Year (integer).
  \item \code{value}: Population (numeric).
  \item \code{value_label}: Formatted population (e.g., "126,000,000").
}
Returns \code{NULL} if API request fails or data is unavailable.
}
\description{
Retrieves Indonesia's total population for the years 2010 to 2022
using the World Bank Open Data API. The indicator used is \code{SP.POP.TOTL}.
}
\details{
If the API request fails for any reason (network issue, timeout,
invalid HTTP status, or malformed JSON), the function returns \code{NULL}
with an informative message.
}
\note{
Requires internet connection.
}
\examples{
\donttest{
get_indonesia_population()
}

}
