% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_analysis.R
\name{get_lambdas}
\alias{get_lambdas}
\title{get_lambdas}
\usage{
get_lambdas(lambda_array, item_names, dim_names, item_elab = NULL)
}
\arguments{
\item{lambda_array}{An array of dimension (K x d x nsamp/thin) containing posterior samples of item discrimination parameters.}

\item{item_names}{Vector of item names.}

\item{dim_names}{Vector of dimension names.}

\item{item_elab}{A vector comprising elaborations about each item (Default = NULL).}
}
\value{
A list containing the following components:
\item{av_lams}{A data frame of dimension (K x (1+d)) containing averages of item discrimination parameters.}
\item{high_lams}{A data frame of dimension (K x d) containing an ordered list of the items with the highest mean values of lambda for each dimension.}
}
\description{
Takes as input the array of lambdas from the irt list,
a vector of item names (can be taken from either Y_in or M_matrix), a vector of dimension names,
and, optionally, a vector comprising elaborations about each item.
Returns a list containing a data frame with the mean lambdas for each item-dimension pair,
possibly attaching elaborations to each item's string,
and a data frame with the items with the highest mean values of lambda for each dimension in order
}
