% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{runif_outside_range}
\alias{runif_outside_range}
\title{Uniform distribution outside a given range}
\usage{
runif_outside_range(n, min = 0, max = 1, mult = 2)
}
\arguments{
\item{n}{an integer giving the number of observations to generate.}

\item{min}{a numeric vector giving the minimum of each variable of the
initial data set (outside of which to generate random noise).}

\item{max}{a numeric vector giving the maximum of each variable of the
initial data set (outside of which to generate random noise).}

\item{mult}{multiplication factor (larger than 1) to expand the
hyperrectangle around the initial data (which is given by \code{min} and \code{max}).
For instance, the default value 2 gives a hyperrectangle for which each
side is twice as long as the range of the initial data.  The data are then
drawn from a uniform distribution on the expanded hyperrectangle from which
the smaller hyperrectangle around the data is cut out. See the examples for
an illustration.}
}
\value{
A matrix of generated points.
}
\description{
Draw from a multivariate uniform distribution outside a given range.
Intuitively speaking, the observations are drawn from a multivariate
uniform distribution on a hyperrectangle with a hole in the middle (in the
shape of a smaller hyperrectangle). This is useful, e.g., for adding random
noise to a data set such that the noise consists of large values that do not
overlap the initial data.
}
\examples{
## illustrations for argument 'mult'

# draw observations with argument 'mult = 2'
xy2 <- runif_outside_range(1000, min = rep(-1, 2), max = rep(1, 2), 
                           mult = 2)
# each side of the larger hyperrectangle is twice as long as 
# the corresponding side of the smaller rectanglar cut-out
df2 <- data.frame(x = xy2[, 1], y = xy2[, 2])
ggplot(data = df2, mapping = aes(x = x, y = y)) + 
  geom_point()

# draw observations with argument 'mult = 4'
xy4 <- runif_outside_range(1000, min = rep(-1, 2), max = rep(1, 2), 
                           mult = 4)
# each side of the larger hyperrectangle is four times as long 
# as the corresponding side of the smaller rectanglar cut-out
df4 <- data.frame(x = xy4[, 1], y = xy4[, 2])
ggplot(data = df4, mapping = aes(x = x, y = y)) + 
  geom_point()

}
\references{
Alfons, A., Archimbaud, A., Nordhausen, K., & Ruiz-Gazen, A. (2024).
Tandem clustering with invariant coordinate selection.
Econometrics and Statistics.
\doi{10.1016/j.ecosta.2024.03.002}.
}
\author{
Andreas Alfons
}
