% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_iblm.R
\name{data_to_onehot}
\alias{data_to_onehot}
\title{Convert Data Frame to Wide One-Hot Encoded Format}
\usage{
data_to_onehot(data, iblm_model, remove_target = TRUE)
}
\arguments{
\item{data}{Input data frame to be transformed. This will typically be the "train" data subset}

\item{iblm_model}{Object of class 'iblm'}

\item{remove_target}{Logical, whether to remove the response_var variable from
the output (default TRUE).}
}
\value{
A data frame in wide format with one-hot encoded categorical variables,
an intercept column, and all variables ordered according to "coeff_names$all" from `iblm_model`
}
\description{
Transforms categorical variables in a data frame into one-hot encoded format
}
\examples{
df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

wide_input_frame <- data_to_onehot(df_list$test, iblm_model)

wide_input_frame |> dplyr::glimpse()

}
